/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.configuration;

import es.bsc.compss.gos.master.GOSAdaptor;
import es.bsc.compss.gos.master.exceptions.GOSException;
import es.bsc.compss.gos.master.monitoring.GOSMonitoring;
import es.bsc.compss.types.resources.configuration.MethodConfiguration;
import java.util.HashMap;
import java.util.Map;

public class GOSConfiguration
extends MethodConfiguration {
    private final GOSMonitoring monitoring;
    private Map<String, Object> resourcesProperties;
    private Map<String, Object> projectProperties;
    private boolean isBatch;
    private final GOSAdaptor adaptor;

    public GOSConfiguration(GOSAdaptor adaptor, GOSMonitoring gosMonitoring) {
        super(GOSAdaptor.ID);
        this.adaptor = adaptor;
        this.monitoring = gosMonitoring;
    }

    public GOSConfiguration(GOSConfiguration clone) {
        super(clone);
        this.adaptor = clone.adaptor;
        this.monitoring = clone.monitoring;
        this.projectProperties = clone.projectProperties;
        this.resourcesProperties = clone.resourcesProperties;
        this.isBatch = clone.isBatch;
    }

    public void addProjectProperties(Map<String, Object> projectProperties) throws GOSException {
        if (projectProperties == null) {
            projectProperties = new HashMap<String, Object>();
        } else {
            this.projectProperties = projectProperties;
        }
        if (!projectProperties.containsKey("Interactive")) {
            LOGGER.warn("[GOSCONFIGURATION] Not clear if is interactive or batch, defaulting to interactive");
            this.isBatch = false;
        } else {
            this.isBatch = (Boolean)this.projectProperties.get("Interactive") == false;
        }
    }

    public void addResourcesProperties(Map<String, Object> resourcesProperties) {
        if (resourcesProperties == null) {
            resourcesProperties = new HashMap<String, Object>();
        }
        this.resourcesProperties = resourcesProperties;
    }

    public GOSAdaptor getAdaptor() {
        return this.adaptor;
    }

    public GOSMonitoring getMonitoring() {
        return this.monitoring;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public Object getProjectProperty(String key) {
        if (this.projectProperties.containsKey(key)) {
            return this.projectProperties.get(key);
        }
        LOGGER.warn(key + " key not in project properties");
        return null;
    }

    public Map<String, Object> getProjectProperty() {
        return this.projectProperties;
    }

    public Map<String, Object> getResourcesProperties() {
        return this.resourcesProperties;
    }
}

