/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.sftpmonitor.GOSJschTransferMonitor;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.gos.master.sshutils.SSHSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSHChannel {
    private static final String DEFAULT_STARTING_PATH = "/";
    private final Channel ch;
    private final SSHSession s;
    private final String type;
    public String reason;

    public SSHChannel(SSHSession sshSession, String type, String reason) throws JSchException {
        this.s = sshSession;
        this.type = type;
        if (!this.s.isConnected()) {
            this.s.connect();
        }
        this.ch = this.s.getSession().openChannel(type);
        this.reason = reason;
    }

    public void disconnect() {
        this.s.updateOpenChannels(this);
        this.releaseResources();
    }

    public void connect() throws JSchException {
        if (!this.ch.isConnected()) {
            this.ch.connect();
        }
    }

    public int getExitStatus() {
        return this.ch.getExitStatus();
    }

    public boolean isConnected() {
        return this.ch.isConnected();
    }

    public void setCommand(String command) throws JSchException {
        ChannelExec exec;
        try {
            exec = (ChannelExec)this.ch;
        }
        catch (Exception e) {
            throw new JSchException("Channel was not of type Exec");
        }
        exec.setCommand(command);
    }

    public void cd(String path) throws SftpException {
        ChannelSftp sftp;
        try {
            sftp = (ChannelSftp)this.ch;
        }
        catch (Exception e) {
            throw new SftpException(1, "Channel was not of type Sftp");
        }
        sftp.cd(path);
    }

    public SftpATTRS lstat(String path) throws SftpException {
        ChannelSftp sftp;
        try {
            sftp = (ChannelSftp)this.ch;
        }
        catch (Exception e) {
            throw new SftpException(1, "Channel was not of type Sftp");
        }
        return sftp.lstat(path);
    }

    public void setOutputStream(OutputStream out) {
        this.ch.setOutputStream(out);
    }

    public void setInputStream(InputStream in) {
        this.ch.setInputStream(in);
    }

    public void setErrStream(OutputStream err) throws JSchException {
        ChannelExec exec;
        try {
            exec = (ChannelExec)this.ch;
        }
        catch (Exception e) {
            throw new JSchException("Channel was not of type Exec");
        }
        exec.setErrStream(err);
    }

    public boolean isClosed() {
        return this.ch.isClosed();
    }

    public InputStream getInputStream() throws IOException {
        return this.ch.getInputStream();
    }

    public InputStream getErrStream() throws JSchException, IOException {
        ChannelExec exec;
        try {
            exec = (ChannelExec)this.ch;
        }
        catch (Exception e) {
            throw new JSchException("Channel was not of type Exec");
        }
        return exec.getErrStream();
    }

    public void put(String src, String dst, GOSJschTransferMonitor monitor) throws SftpException {
        ChannelSftp sftp = (ChannelSftp)this.ch;
        sftp.put(src, dst, (SftpProgressMonitor)monitor);
    }

    public void get(String src, String dst, GOSJschTransferMonitor monitor) throws SftpException {
        ChannelSftp sftp = (ChannelSftp)this.ch;
        sftp.get(src, dst, (SftpProgressMonitor)monitor);
    }

    public void get(String src, String dst, GOSJschTransferMonitor monitor, int mode) throws SftpException {
        ChannelSftp sftp = (ChannelSftp)this.ch;
        sftp.get(src, dst, monitor, mode);
    }

    public String pwd() throws SftpException {
        ChannelSftp sftp = (ChannelSftp)this.ch;
        return sftp.pwd();
    }

    public void releaseResources() {
        if (this.ch.isConnected()) {
            this.ch.disconnect();
        }
    }

    public SSHHost getHost() {
        return this.s.getHost();
    }

    public SSHChannel recreateChannel() throws JSchException {
        this.releaseResources();
        return this.s.recreateChannel(this, this.type);
    }

    public void delete(String path) throws SftpException {
        ChannelSftp channelSftp = (ChannelSftp)this.ch;
        channelSftp.rm(path);
    }
}

