/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.gos.master.sshutils.SSHSessionManager;
import java.util.Collection;
import java.util.HashSet;

public class SSHSession {
    private final SSHSessionManager sessionManager;
    private Session session;
    private final HashSet<SSHChannel> openChannels;
    private final int maxChannels;
    private static int Created = 1;
    final String id;

    public SSHSession(SSHSessionManager sm, Session s, int maxChannels) {
        this.sessionManager = sm;
        this.session = s;
        this.id = Created++ + "_" + sm.getHost().getFullHostName();
        this.setConfig();
        this.maxChannels = Math.max(maxChannels, 1);
        this.openChannels = new HashSet(maxChannels);
    }

    private void setConfig() {
        this.session.setConfig("StrictHostKeyChecking", "no");
        this.session.setConfig("PreferredAuthentications", "publickey");
    }

    public void connect() throws JSchException {
        if (!this.session.isConnected()) {
            try {
                this.session.connect();
            }
            catch (JSchException e) {
                if (e.getLocalizedMessage().equals("Packet corrupt")) {
                    this.recreateSession();
                    this.session.connect();
                }
                throw e;
            }
        }
    }

    private void recreateSession() throws JSchException {
        this.session.disconnect();
        this.session = this.sessionManager.recreateSession();
        this.setConfig();
    }

    public void updateOpenChannels(SSHChannel ch) {
        this.openChannels.remove(ch);
        this.sessionManager.updateOpenSession(this);
    }

    public void releaseAllResources() {
        for (SSHChannel ch : this.openChannels) {
            ch.releaseResources();
        }
        this.releaseResource();
        this.openChannels.clear();
    }

    private void releaseResource() {
        this.session.disconnect();
    }

    public SSHChannel openChannel(String type, String reason) throws JSchException {
        SSHChannel ch = new SSHChannel(this, type, reason);
        this.openChannels.add(ch);
        return ch;
    }

    public Session getSession() {
        return this.session;
    }

    public boolean canAddChannel() {
        return this.openChannels.size() < this.maxChannels;
    }

    public boolean isEmpty() {
        return this.openChannels.isEmpty();
    }

    public Collection<? extends SSHChannel> getChannels() {
        return this.openChannels;
    }

    public SSHHost getHost() {
        return this.sessionManager.getHost();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public SSHChannel recreateChannel(SSHChannel old, String type) throws JSchException {
        SSHChannel ch = this.openChannel(type, old.reason);
        this.openChannels.remove(old);
        this.openChannels.add(ch);
        return ch;
    }
}

