/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations;

import es.bsc.compss.types.implementations.ExecutionOrder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExecType
implements Externalizable {
    public static int ARRAY_LENGTH = 3;
    private String binary;
    private String params;
    private boolean failByExitValue;
    private ExecutionOrder order;

    public ExecType(ExecutionOrder order, String binary, String params, boolean failByExitValue) {
        this.binary = binary;
        this.params = params;
        this.order = order;
        this.failByExitValue = failByExitValue;
    }

    public ExecType() {
    }

    public String getBinary() {
        return this.binary;
    }

    public void setBinary(String binary) {
        this.binary = binary;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public ExecutionOrder getOrder() {
        return this.order;
    }

    public boolean isFailByExitValue() {
        return this.failByExitValue;
    }

    public boolean isAssigned() {
        return this.binary != null && !this.binary.isEmpty() && !this.binary.equals("[unassigned]");
    }

    public void setFailByExitValue(boolean failByExitValue) {
        this.failByExitValue = failByExitValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.order);
        out.writeObject(this.binary);
        out.writeObject(this.params);
        out.writeBoolean(this.failByExitValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.order = (ExecutionOrder)((Object)in.readObject());
        this.binary = (String)in.readObject();
        this.params = (String)in.readObject();
        this.failByExitValue = in.readBoolean();
    }
}

