/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPool {
    static final Logger logger = LoggerFactory.getLogger(ThreadPool.class);
    private static final LinkedList<PoolThread> threadPool = new LinkedList();

    private ThreadPool() {
    }

    private static synchronized void waiting(PoolThread thread) {
        threadPool.add(thread);
    }

    public static synchronized void createNew(Runnable runnable, String name) {
        PoolThread poolThread;
        if (!threadPool.isEmpty()) {
            poolThread = threadPool.removeLast();
            if (poolThread.issue(runnable, name)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("clearing thread pool of size " + threadPool.size());
            }
            threadPool.clear();
        }
        poolThread = new PoolThread(runnable, name);
        poolThread.setDaemon(true);
        poolThread.start();
    }

    private static final class PoolThread
    extends Thread {
        private static final int TIMEOUT = 30000;
        Runnable work = null;
        String name = null;
        boolean expired = false;
        private static int nrOfThreads;
        private static int maxSimultaneousThreads;

        private static synchronized void newThread(String name) {
            if (++nrOfThreads > maxSimultaneousThreads) {
                maxSimultaneousThreads = nrOfThreads;
            }
            logger.debug("New Thread \"" + name + "\" createded, number of threads now: " + nrOfThreads);
        }

        private static synchronized void threadGone() {
            logger.debug("Thread removed from pool. Now " + --nrOfThreads + " threads");
        }

        private PoolThread() {
        }

        PoolThread(Runnable runnable, String name) {
            this.work = runnable;
            this.name = name;
            if (logger.isInfoEnabled()) {
                PoolThread.newThread(name);
            }
        }

        private synchronized boolean issue(Runnable newWork, String newName) {
            if (this.expired) {
                logger.debug("issue(): thread has expired");
                return false;
            }
            if (this.work != null) {
                throw new Error("tried to issue work to already running poolthread");
            }
            this.work = newWork;
            this.name = newName;
            logger.trace("issue(): reusing thread");
            this.notifyAll();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                String currentName;
                Runnable currentWork;
                PoolThread poolThread = this;
                synchronized (poolThread) {
                    if (this.work == null) {
                        ThreadPool.waiting(this);
                        try {
                            this.wait(30000L);
                        }
                        catch (InterruptedException e) {
                            this.expired = true;
                            if (logger.isInfoEnabled()) {
                                PoolThread.threadGone();
                            }
                            return;
                        }
                    }
                    if (this.work == null) {
                        this.expired = true;
                        if (logger.isInfoEnabled()) {
                            PoolThread.threadGone();
                        }
                        return;
                    }
                    currentWork = this.work;
                    currentName = this.name;
                }
                try {
                    this.setName(currentName);
                    currentWork.run();
                    this.setName("idle threadpool thread");
                }
                catch (Throwable t) {
                    logger.error("caught exception in pool thread " + currentName, t);
                    System.exit(1);
                }
                poolThread = this;
                synchronized (poolThread) {
                    this.work = null;
                    this.name = null;
                }
            }
        }

        static {
            Runtime.getRuntime().addShutdownHook(new ThreadPoolShutdown());
            nrOfThreads = 0;
            maxSimultaneousThreads = 0;
        }

        private static final class ThreadPoolShutdown
        extends Thread {
            private ThreadPoolShutdown() {
            }

            public void run() {
                Logger logger = LoggerFactory.getLogger(ThreadPool.class);
                logger.info("maximum number of simultaneous threads was: " + maxSimultaneousThreads);
            }
        }
    }
}

