/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.COMPSsPaths;
import es.bsc.compss.types.MPIProgram;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.types.implementations.definition.CommonMPIDefinition;
import es.bsc.compss.types.resources.ContainerDescription;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;

public class MpmdMPIDefinition
extends CommonMPIDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 5;
    public static final String SIGNATURE = "mpmdmpi.MPMDMPI";
    private static final String ERROR_MPI_BINARY = "ERROR: Empty binary annotation for MPMDMPI method";
    private MPIProgram[] programs;
    private static final String DUMMY_SEPARATOR = "_<<>>_";
    private boolean totalNopInCMD = false;
    private boolean binaryInCmd = false;
    private boolean hostStringInCmd = false;
    private boolean nopInCmd = false;
    private boolean configFile = false;
    private boolean hostfile = false;
    private boolean assignPPN = false;
    private String totalNopFlag = "-n";
    private String programsSeparator = ":";
    private String hostFileFlag = "--hostfile";
    private String hostFlag = "--host";
    private String hostSeparator = ",";
    private String ppnSeparator = " ";
    private String nopFlag = "-n";
    private boolean isNopByRank = false;
    private String configFlag = "--config-file";
    private ContainerDescription container;

    public MpmdMPIDefinition() {
    }

    public MpmdMPIDefinition(String workingDir, String mpiRunner, int ppn, boolean failByEV, MPIProgram[] programs) {
        super(workingDir, mpiRunner, ppn, "", false, failByEV);
        this.programs = programs;
    }

    public MpmdMPIDefinition(String[] implTypeArgs, int offset, String[] container) {
        this.mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.ppn = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]));
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 3]);
        int numOfProgs = Integer.parseInt(implTypeArgs[offset + 4]);
        this.programs = new MPIProgram[numOfProgs];
        for (int i = 0; i < numOfProgs; ++i) {
            int index = offset + 5 + i * 3;
            String binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[index]);
            String params = EnvironmentLoader.loadFromEnvironment(implTypeArgs[index + 1]);
            int procs = Integer.parseInt(EnvironmentLoader.loadFromEnvironment(implTypeArgs[index + 2]));
            this.programs[i] = new MPIProgram(binary, params, procs);
        }
        if (container[0] != null && !container[0].isEmpty() && !container[0].equals("[unassigned]")) {
            String engineStr = container[0].toUpperCase();
            ContainerDescription.ContainerEngine engine = ContainerDescription.ContainerEngine.valueOf(engineStr);
            this.container = new ContainerDescription(engine, container[1], container[2]);
        } else {
            this.container = null;
        }
        this.checkArguments();
    }

    public MPIProgram[] getPrograms() {
        return this.programs;
    }

    @Override
    public void checkArguments() {
        super.checkArguments();
        for (MPIProgram mpiProgram : this.programs) {
            if (!mpiProgram.isEmpty()) continue;
            throw new IllegalArgumentException(ERROR_MPI_BINARY);
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.mpiRunner);
        lArgs.add(this.workingDir);
        lArgs.add(Integer.toString(this.ppn));
        lArgs.add(Boolean.toString(this.failByEV));
        lArgs.add(Integer.toString(this.programs.length));
        for (MPIProgram program : this.programs) {
            lArgs.add(program.getBinary());
            if (this.container != null) {
                lArgs.add(this.container.getEngine().name().toLowerCase());
                lArgs.add(this.container.getEngine().equals((Object)ContainerDescription.ContainerEngine.SINGULARITY) ? "exec" : "run");
                for (String tmp : this.container.getOptions().split(" ")) {
                    lArgs.add(tmp);
                }
                lArgs.add(this.container.getImage());
            }
            lArgs.add(program.getParams());
            lArgs.add(Integer.toString(program.getProcesses()));
        }
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MPMDMPI;
    }

    public ContainerDescription getContainer() {
        return this.container;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[MPMDMPI").append(this.mpiRunner);
        sb.append(", MPI RUNNER=").append(this.mpiRunner);
        sb.append(", WORKING DIR=").append(this.workingDir);
        sb.append(", PPN=").append(this.ppn);
        sb.append(", FAIL_BY_EV=").append(this.failByEV);
        sb.append(", NUM_OF_PROGRAMS=").append(this.programs.length);
        sb.append(", CONTAINER=").append(this.container);
        sb.append(", PROGRAMS= [\n");
        for (MPIProgram program : this.getPrograms()) {
            sb.append("\t").append(program.toString()).append(", \n");
        }
        sb.append(" \t ]\n");
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return "MPMDMPI Method with MPIRunner " + this.mpiRunner + ", and " + this.programs.length + " programs.";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mpiRunner = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.ppn = in.readInt();
        this.failByEV = in.readBoolean();
        this.programs = (MPIProgram[])in.readObject();
        this.container = (ContainerDescription)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.mpiRunner);
        out.writeObject(this.workingDir);
        out.writeInt(this.ppn);
        out.writeBoolean(this.failByEV);
        out.writeObject(this.programs);
        out.writeObject(this.container);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MPMDMPI Implementation \n");
        sb.append("\t MPI runner: ").append(this.mpiRunner).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t MPI PPN: ").append(this.ppn).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        sb.append("\t Programs: ").append("\n");
        sb.append("\t Container: ").append(this.container).append("\n");
        for (MPIProgram prog : this.programs) {
            sb.append("\t\t").append(prog).append("\n");
        }
        return sb.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    @Override
    public String generateNumberOfProcesses(int numWorkers, int computingUnits) {
        return null;
    }

    public String[] generateCMD(File taskSandboxWorkingDir, List<String> hostnames, int computingUnits, ContainerDescription container) throws IOException {
        String content;
        for (int i = 0; i < hostnames.size(); ++i) {
            String tmp = hostnames.get(i);
            if (!tmp.endsWith("-ib0")) continue;
            hostnames.set(i, tmp.substring(0, tmp.lastIndexOf("-ib0")));
        }
        StringBuilder cmd = new StringBuilder();
        String masterContImage = System.getenv("MASTER_CONTAINER_IMAGE");
        if (masterContImage != null && !masterContImage.isEmpty()) {
            String script = System.getenv("MPI_RUNNER_SCRIPT");
            cmd.append(script).append(DUMMY_SEPARATOR);
        }
        cmd.append(this.mpiRunner).append(DUMMY_SEPARATOR);
        if (this.totalNopInCMD) {
            cmd.append(this.totalNopFlag).append(DUMMY_SEPARATOR);
            cmd.append(this.getTotalNumOfProcesses()).append(DUMMY_SEPARATOR);
        }
        if (this.hostfile) {
            content = this.buildHostFileString(hostnames, computingUnits);
            String string = MpmdMPIDefinition.writeToFile(taskSandboxWorkingDir, content, ".hostfile");
            cmd.append(this.hostFileFlag).append(DUMMY_SEPARATOR).append(string).append(DUMMY_SEPARATOR);
        }
        if (this.binaryInCmd) {
            ArrayList<String> fullCmd = new ArrayList<String>(Arrays.asList(cmd.toString().split(DUMMY_SEPARATOR)));
            for (MPIProgram program : this.programs) {
                String tmp = this.buildSPString(program, hostnames);
                fullCmd.addAll(Arrays.asList(tmp.split(DUMMY_SEPARATOR)));
                if (program.hasParamsString()) {
                    fullCmd.addAll(Arrays.asList(program.getParamsArray()));
                }
                fullCmd.add(this.programsSeparator);
            }
            String[] stringArray = new String[fullCmd.size()];
            return fullCmd.toArray(stringArray);
        }
        if (this.hostStringInCmd) {
            cmd.append(this.buildHostsString(hostnames)).append(DUMMY_SEPARATOR);
        }
        if (this.configFile) {
            content = this.buildConfigFileString(hostnames);
            String string = MpmdMPIDefinition.writeToFile(taskSandboxWorkingDir, content, ".config");
            cmd.append(this.configFlag).append(DUMMY_SEPARATOR).append(string);
        }
        return cmd.toString().split(DUMMY_SEPARATOR);
    }

    private String buildHostFileString(List<String> hostnames, int computingUnits) {
        return MpmdMPIDefinition.buildHostsString(hostnames, computingUnits, this.ppn, this.ppnSeparator, this.hostSeparator, false);
    }

    private String buildConfigFileString(List<String> hostnames) {
        StringBuilder content = new StringBuilder();
        int offset = 0;
        for (MPIProgram program : this.programs) {
            if (!this.hostStringInCmd) {
                content.append(this.hostFlag).append(" ");
                for (int i = 0; i < hostnames.size(); ++i) {
                    content.append(hostnames.get(i));
                    if (i >= hostnames.size() - 1) continue;
                    content.append(this.hostSeparator);
                }
                content.append(" ");
            }
            if (!this.nopInCmd) {
                content.append(this.buildNopString(program, offset)).append(" ");
                if (this.isNopByRank) {
                    offset += program.getProcesses();
                }
            }
            if (!this.binaryInCmd) {
                if (this.container != null) {
                    content.append(this.container.getEngine().name().toLowerCase()).append(" ");
                    content.append(this.container.getEngine().equals((Object)ContainerDescription.ContainerEngine.SINGULARITY) ? "exec" : "run").append(" ");
                    if (!this.container.getOptions().isEmpty() && !this.container.getOptions().equals("[unassigned]")) {
                        for (String tmp : this.container.getOptions().split(" ")) {
                            content.append(tmp).append(" ");
                        }
                    }
                    content.append(this.container.getImage()).append(" ");
                }
                content.append(program.getBinary());
            }
            if (program.hasParamsString()) {
                content.append(" ").append(program.getParams());
            }
            content.append("\n");
        }
        return content.toString();
    }

    private static String writeToFile(File taskSandboxWorkingDir, String content, String extension) throws IOException {
        String uuid = UUID.randomUUID().toString();
        String filename = taskSandboxWorkingDir.getAbsolutePath() + File.separator + uuid + extension;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filename));){
            writer.write(content);
        }
        return filename;
    }

    private int getTotalNumOfProcesses() {
        int ret = 0;
        for (MPIProgram program : this.programs) {
            ret += program.getProcesses();
        }
        return ret;
    }

    private String buildSPString(MPIProgram program, List<String> hostnames) {
        StringBuilder ret = new StringBuilder();
        if (this.hostStringInCmd) {
            ret.append(this.buildHostsString(hostnames)).append(DUMMY_SEPARATOR);
        }
        if (this.nopInCmd) {
            ret.append(this.nopFlag).append(DUMMY_SEPARATOR);
            ret.append(program.getProcesses()).append(DUMMY_SEPARATOR);
        }
        if (this.container != null) {
            ret.append(this.container.getEngine().name().toLowerCase());
            ret.append(this.container.getEngine().equals((Object)ContainerDescription.ContainerEngine.SINGULARITY) ? "exec" : "run");
            for (String tmp : this.container.getOptions().split(" ")) {
                ret.append(tmp);
            }
            ret.append(this.container.getImage());
        }
        ret.append(program.getBinary());
        return ret.toString();
    }

    private String buildHostsString(List<String> hostnames) {
        StringBuilder ret = new StringBuilder();
        ret.append(this.hostFlag);
        for (int i = 0; i < hostnames.size(); ++i) {
            ret.append(hostnames.get(i));
            if (i >= hostnames.size() - 1) continue;
            ret.append(this.hostSeparator);
        }
        return ret.toString();
    }

    private String buildNopString(MPIProgram program, int offSet) {
        StringBuilder ret = new StringBuilder();
        if (this.nopFlag != null && !this.nopFlag.isEmpty()) {
            ret.append(this.nopFlag).append(" ");
        }
        if (this.isNopByRank) {
            for (int i = 0; i < program.getProcesses(); ++i) {
                ret.append(offSet + i);
                if (i >= program.getProcesses() - 1) continue;
                ret.append(",");
            }
        } else {
            ret.append(program.getProcesses());
        }
        return ret.toString();
    }

    @Override
    public void setRunnerProperties(String installDir) {
        if (this.mpiRunner.endsWith("srun")) {
            this.loadMPIType(installDir + COMPSsPaths.REL_MPI_CFGS_DIR + "slurm.properties");
        } else {
            String type = System.getenv("COMPSS_MPIRUN_TYPE");
            if (type != null && !type.isEmpty()) {
                LOGGER.info("Loading MPIRUN type: " + type);
                if (type.startsWith(File.separator)) {
                    this.loadMPIType(type);
                } else {
                    this.loadMPIType(installDir + COMPSsPaths.REL_MPI_CFGS_DIR + type + ".properties");
                }
            } else {
                LOGGER.warn("Loading default MPIRUN type. You can modify with COMPSS_MPIRUN_TYPE environment variable.");
            }
        }
    }

    private void loadMPIType(String file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Properties props = new Properties();
            props.load(fis);
            this.totalNopInCMD = Boolean.parseBoolean(this.loadProperty(props, "mpmd.total.nop.in.cmd", "false"));
            this.binaryInCmd = Boolean.parseBoolean(this.loadProperty(props, "mpmd.binary.in.cmd", "false"));
            this.hostStringInCmd = Boolean.parseBoolean(this.loadProperty(props, "mpmd.hosts.string.in.cmd", "false"));
            this.hostfile = Boolean.parseBoolean(this.loadProperty(props, "mpmd.hostfile", "false"));
            this.nopInCmd = Boolean.parseBoolean(this.loadProperty(props, "mpmd.nop.string.in.cmd", "false"));
            this.configFile = Boolean.parseBoolean(this.loadProperty(props, "mpmd.config.file", "false"));
            this.assignPPN = Boolean.parseBoolean(this.loadProperty(props, "mpmd.assign.ppn", "false"));
            this.programsSeparator = this.loadProperty(props, "mpmd.programs.separator", ":");
            this.hostFlag = this.loadProperty(props, "mpmd.hosts.flag", "--host");
            this.hostFileFlag = this.loadProperty(props, "mpmd.hostfile.flag", "--hostfile");
            this.hostSeparator = this.loadProperty(props, "mpmd.hosts.separator", ",");
            this.ppnSeparator = this.loadProperty(props, "mpmd.ppn.separator", " ");
            this.totalNopFlag = this.loadProperty(props, "mpmd.total.nop.flag", "-n");
            this.nopFlag = this.loadProperty(props, "mpmd.nop.flag", "-n");
            this.isNopByRank = Boolean.parseBoolean(this.loadProperty(props, "mpmd.nop.is.rank", "false"));
            this.configFlag = this.loadProperty(props, "mpmd.config.flag", "-n");
        }
        catch (Exception e) {
            LOGGER.warn("Can't load MPIRUN type in " + file + ".\nReason: " + e.getMessage());
        }
    }
}

