/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.transfermonitor;

import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSGlobalTransferMonitor {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final HashMap<Integer, GOSTransferMonitor> activeTransfers = new HashMap();

    public void addTransferMonitor(GOSTransferMonitor m) {
        this.activeTransfers.put(m.getID(), m);
    }

    public boolean monitor() {
        for (Object o : this.activeTransfers.values().toArray()) {
            GOSTransferMonitor tm = (GOSTransferMonitor)o;
            if (!tm.monitor()) continue;
            this.removeTransferMonitor(tm.getID());
        }
        return this.existsActiveTransfers();
    }

    public synchronized void removeTransferMonitor(int id) {
        this.activeTransfers.remove(id);
    }

    public boolean existsActiveTransfers() {
        return !this.activeTransfers.isEmpty();
    }

    public void end() {
        LOGGER.info("Ending global transfer monitor");
        for (GOSTransferMonitor tm : this.activeTransfers.values()) {
            tm.shutdown();
        }
        this.activeTransfers.clear();
    }
}

