/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.job;

import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.operation.DataOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JobTransfersListener
extends EventListener {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.FileTransferManager");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private int operation = 0;
    private int errors = 0;
    private boolean enabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        boolean failed;
        boolean finished;
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            this.enabled = true;
            finished = this.operation == 0;
            failed = this.errors > 0;
        }
        if (finished) {
            if (failed) {
                this.stageInFailed(this.errors);
            } else {
                this.stageInCompleted();
            }
        }
    }

    public synchronized void addOperation() {
        ++this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEnd(DataOperation fOp) {
        boolean enabled;
        boolean failed;
        boolean finished;
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            --this.operation;
            finished = this.operation == 0;
            failed = this.errors > 0;
            enabled = this.enabled;
        }
        if (finished && enabled) {
            if (failed) {
                this.stageInFailed(this.errors);
            } else {
                this.stageInCompleted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFailure(DataOperation fOp, Exception e) {
        boolean enabled;
        boolean finished;
        String fOpName = "None";
        if (fOp != null) {
            fOpName = fOp.getName();
        }
        if (DEBUG) {
            LOGGER.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOpName + ", file role is JOB_FILE, operation end state is FAILED", (Throwable)e);
        } else {
            LOGGER.error("THREAD " + Thread.currentThread().getName() + " File Operation failed on " + fOpName + ", file role is JOB_FILE operation end state is FAILED");
        }
        JobTransfersListener jobTransfersListener = this;
        synchronized (jobTransfersListener) {
            ++this.errors;
            --this.operation;
            finished = this.operation == 0;
            enabled = this.enabled;
        }
        if (enabled && finished) {
            this.stageInFailed(this.errors);
        }
    }

    public abstract void stageInCompleted();

    public abstract void stageInFailed(int var1);
}

