/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.jobmonitor;

import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostsManager;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSSingleJobManager;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class GOSHostsInteractiveManager
implements GOSHostsManager {
    protected final ConcurrentHashMap<String, GOSSingleJobManager> activeJobs = new ConcurrentHashMap();

    public GOSHostsInteractiveManager(GOSJob job) {
        this.addJobMonitor(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJobMonitor(GOSJob job) {
        ConcurrentHashMap<String, GOSSingleJobManager> concurrentHashMap = this.activeJobs;
        synchronized (concurrentHashMap) {
            this.activeJobs.put(job.getCompositeID(), new GOSSingleJobManager(job));
        }
    }

    @Override
    public boolean existsRunningJobs() {
        return !this.activeJobs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        if (this.activeJobs.isEmpty()) {
            return;
        }
        GOSSingleJobManager[] jobs = null;
        GOSSingleJobManager[] gOSSingleJobManagerArray = this.activeJobs;
        synchronized (this.activeJobs) {
            Collection<GOSSingleJobManager> col = this.activeJobs.values();
            if (!col.isEmpty()) {
                jobs = col.toArray(new GOSSingleJobManager[col.size()]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (jobs == null) {
                return;
            }
            for (GOSSingleJobManager sjm : jobs) {
                if (!sjm.monitor()) continue;
                this.removeJobMonitorID(sjm.getID());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeJobMonitorID(String id) {
        ConcurrentHashMap<String, GOSSingleJobManager> concurrentHashMap = this.activeJobs;
        synchronized (concurrentHashMap) {
            this.activeJobs.remove(id);
        }
    }

    @Override
    public int countActiveJobs() {
        return this.activeJobs.size();
    }

    @Override
    public void shutdown() {
        for (GOSSingleJobManager jm : this.activeJobs.values()) {
            jm.shutdown();
        }
        this.activeJobs.clear();
    }

    @Override
    public void removeJobMonitor(GOSJob job) {
        this.removeJobMonitorID(job.getCompositeID());
    }
}

