/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.ErrorHandler;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ErrorManager {
    public static final String NEWLINE = "\r\n";
    private static final String REGEX_NEWLINE = "\r\n|\n|\r";
    private static final String PREFIX_ERRMGR = "[ERRMGR]  -  ";
    private static final String PREFIX_WARNING = "[ERRMGR]  -  WARNING: ";
    private static final String PREFIX_ERROR = "[ERRMGR]  -  ERROR:   ";
    private static final String PREFIX_FATAL = "[ERRMGR]  -  FATAL:   ";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.ErrorManager");
    private static ErrorHandler handler = null;
    private static boolean stopping = false;

    public static void init(ErrorHandler handler) {
        ErrorManager.handler = handler;
    }

    public static void warn(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_WARNING, msg, e, System.err);
        }
        if (LOGGER != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                LOGGER.warn(line);
            }
        }
    }

    public static void warn(Exception e) {
        ErrorManager.warn("", e);
    }

    public static void warn(String msg) {
        ErrorManager.warn(msg, null);
    }

    public static synchronized void error(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_ERROR, msg, e, System.err);
            stopping = handler.handleError();
        }
        if (LOGGER != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                LOGGER.error(line);
            }
        }
    }

    public static void error(Exception e) {
        ErrorManager.error("", e);
    }

    public static void error(String msg) {
        ErrorManager.error(msg, null);
    }

    public static synchronized void fatal(String msg, Exception e) {
        if (!stopping) {
            ErrorManager.prettyPrint(PREFIX_FATAL, msg, e, System.err);
            stopping = handler.handleFatalError();
        }
        if (LOGGER != null) {
            for (String line : msg.split(REGEX_NEWLINE)) {
                LOGGER.fatal(line);
            }
        }
    }

    public static void fatal(Exception e) {
        ErrorManager.fatal("", e);
    }

    public static void fatal(String msg) {
        ErrorManager.fatal(msg, null);
    }

    public static void info(String message, Exception e, PrintStream channel) {
        ErrorManager.prettyPrint(PREFIX_ERRMGR, message, e, channel);
    }

    public static void logInfo(String message, Exception e) {
        LOGGER.info(PREFIX_ERRMGR + message, (Throwable)e);
    }

    public static void logError(String message, Exception e) {
        LOGGER.error(PREFIX_ERRMGR + message, (Throwable)e);
    }

    private static void prettyPrint(String prefix, String msg, Exception e, PrintStream ps) {
        String prettyMsg = msg;
        if (e != null) {
            prettyMsg = prettyMsg + NEWLINE;
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            prettyMsg = prettyMsg + "Stack trace:\r\n" + sw.toString();
        }
        String[] lines = prettyMsg.split(REGEX_NEWLINE);
        for (int i = 0; i < lines.length; ++i) {
            String l = lines[i];
            l = i == 0 ? prefix + l : ErrorManager.indent(l, prefix.length());
            ps.println(l);
        }
    }

    private static String indent(String str, int indentation) {
        for (int j = 0; j < indentation; ++j) {
            str = " " + str;
        }
        return str;
    }

    private ErrorManager() {
        throw new UnsupportedOperationException();
    }
}

