/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils.staticmethods;

import com.jcraft.jsch.JSchException;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.GOSJobDescription;
import es.bsc.compss.gos.master.exceptions.GOSException;
import es.bsc.compss.gos.master.exceptions.GOSWarningException;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public class SSHCommand {
    public static SSHChannel executeCommandBatch(SSHHost host, GOSJobDescription jd, String outputFile, String errorFile) throws JSchException {
        FileOutputStream errorStream;
        FileOutputStream outputStream;
        String executable = jd.getExecutable();
        String options = jd.getCommandArgsBatch();
        String arguments = jd.getArgumentsString();
        String executionCommand = executable + " " + options + " " + arguments;
        SSHChannel channel = host.openChannel("exec", jd.getID() + " commBatch");
        channel.setCommand(executionCommand);
        channel.setInputStream(null);
        try {
            outputStream = new FileOutputStream(outputFile);
            errorStream = new FileOutputStream(errorFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        channel.setOutputStream(outputStream);
        channel.setErrStream(errorStream);
        channel.connect();
        return channel;
    }

    public static BufferedReader executeCommand(SSHHost sshHost, String command) throws JSchException, GOSWarningException {
        SSHChannel channel = sshHost.openChannel("exec", "executeCommand " + command);
        channel.setCommand(command);
        BufferedReader reader = null;
        BufferedReader errReader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(channel.getInputStream()));
            errReader = new BufferedReader(new InputStreamReader(channel.getErrStream()));
        }
        catch (IOException ex) {
            ErrorManager.error("Error in executing command", ex);
        }
        channel.connect();
        boolean running = true;
        while (running) {
            running = channel.getExitStatus() == -1;
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        channel.disconnect();
        if (channel.getExitStatus() != 0) {
            GOSException e = new GOSException("Error in command : " + command + " to " + sshHost.getFullHostName());
            StringBuilder output = new StringBuilder();
            try {
                while (errReader.ready()) {
                    output.append(errReader.readLine());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (channel.getExitStatus() == 100) {
                throw new GOSWarningException("Non-fatal error: " + output);
            }
            ErrorManager.error(sshHost.getFullHostName() + " Error in ssh command. Output: \n" + output, e);
        }
        return reader;
    }

    public static SSHChannel executeCommand(SSHHost sshHost, String command, String executionArguments, String outputFile, String errorFile, String reason) throws JSchException {
        FileOutputStream errorStream;
        FileOutputStream outputStream;
        String executionCommand = command + " " + executionArguments;
        String r = "executeCommand arraylist";
        if (!reason.equals(null)) {
            r = reason;
        }
        SSHChannel channel = sshHost.openChannel("exec", r);
        channel.setCommand(executionCommand);
        channel.setInputStream(null);
        try {
            outputStream = new FileOutputStream(outputFile);
            errorStream = new FileOutputStream(errorFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        channel.setOutputStream(outputStream);
        channel.setErrStream(errorStream);
        channel.connect();
        return channel;
    }

    public static SSHChannel executeCommand(GOSJobDescription jd) throws JSchException {
        return SSHCommand.executeCommand(jd.getSSHHost(), jd.getExecutable(), jd.getArgumentsString(), jd.getOutput(), jd.getOutputError(), jd.getID() + " command");
    }

    public static SSHChannel killJob(SSHHost sshHost, String killCommand, String pathResponse, GOSJob job, String outFile, String errFile) throws JSchException, FileNotFoundException {
        SSHChannel channel = sshHost.openChannel("exec", "cancelJob " + job.getCompositeID());
        String executionCommand = "sh " + killCommand + " " + pathResponse;
        channel.setCommand(executionCommand);
        FileOutputStream outputStream = new FileOutputStream(outFile, true);
        FileOutputStream errorStream = new FileOutputStream(errFile, true);
        channel.setErrStream(errorStream);
        channel.setOutputStream(outputStream);
        channel.connect();
        return channel;
    }
}

