/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.execution.exceptions;

import es.bsc.compss.types.execution.exceptions.NonExistentDataException;
import java.util.LinkedList;
import java.util.List;

public class NonExistentElementException
extends NonExistentDataException {
    private static final long serialVersionUID = 2L;
    private List<NonExistentDataException> subExceptions = new LinkedList<NonExistentDataException>();

    public NonExistentElementException(String dataName, List<NonExistentDataException> subExceptions) {
        super(dataName);
        this.subExceptions = subExceptions;
    }

    @Override
    public List<String> getMissingData() {
        LinkedList<String> missingData = new LinkedList<String>();
        for (NonExistentDataException e : this.subExceptions) {
            missingData.addAll(e.getMissingData());
        }
        return missingData;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Data " + this.dataName + "'s subelements [");
        LinkedList<String> subelementsAsList = new LinkedList<String>();
        for (NonExistentDataException e : this.subExceptions) {
            subelementsAsList.add(String.join((CharSequence)",", e.getMissingData()));
        }
        sb.append(String.join((CharSequence)",", subelementsAsList));
        sb.append("] do not exists.");
        return sb.toString();
    }
}

