/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class MPIProgram
implements Externalizable {
    public static final int NUM_OF_PARAMS = 3;
    private String binary;
    private String params;
    private int processes;
    private String[] paramsArray;

    public MPIProgram() {
        this.binary = "";
        this.params = "";
        this.processes = -1;
    }

    public MPIProgram(String binary, String params, int processes) {
        this.binary = binary;
        this.params = params;
        this.processes = processes;
    }

    public String getBinary() {
        return this.binary;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public int getProcesses() {
        return this.processes;
    }

    public String[] getParamsArray() {
        return this.paramsArray;
    }

    public void setParamsArray(String[] paramsArray) {
        this.paramsArray = paramsArray;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.binary = (String)in.readObject();
        this.params = (String)in.readObject();
        this.processes = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.binary);
        out.writeObject(this.params);
        out.writeInt(this.processes);
    }

    public boolean isEmpty() {
        return this.binary == null || this.binary.isEmpty();
    }

    public String toString() {
        return "MPIProgram{binary='" + this.binary + '\'' + ", params='" + this.params + '\'' + ", processes=" + this.processes + '}';
    }

    public boolean hasParamsString() {
        return this.params != null && !this.params.isEmpty() && !this.params.equals("[unassigned]");
    }
}

