/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.transfermonitor;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.gos.master.GOSCopy;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import java.io.BufferedReader;
import java.io.IOException;

public class GOSSameHostCopyMonitor
implements GOSTransferMonitor {
    public static final int SSH_FX_NO_SUCH_FILE = 2;
    private final GOSCopy copy;
    private final SSHChannel exec;
    private SSHChannel sftp;
    private final BufferedReader errStream;
    private final long targetSize;
    private final String dst;
    private boolean firstNotFound;

    public GOSSameHostCopyMonitor(GOSCopy copy, SSHChannel exec, SSHChannel sftp, BufferedReader errStream, String dst, long size) {
        this.copy = copy;
        this.exec = exec;
        this.sftp = sftp;
        this.errStream = errStream;
        this.dst = dst;
        this.targetSize = size;
        this.firstNotFound = false;
    }

    private long getRemoteFileSize(String dst) throws SftpException, JSchException {
        if (!this.sftp.isConnected()) {
            this.sftp = this.sftp.recreateChannel();
            this.sftp.connect();
        }
        return this.sftp.lstat(dst).getSize();
    }

    @Override
    public boolean monitor() {
        long fileSize;
        try {
            fileSize = this.getRemoteFileSize(this.dst);
        }
        catch (SftpException e) {
            e.printStackTrace();
            if (e.id == 2) {
                if (!this.firstNotFound) {
                    this.firstNotFound = true;
                    return false;
                }
                this.copy.logError("File not found a second time.", e);
            } else {
                this.copy.logError("File detected but error", e);
                StringBuilder sb = new StringBuilder();
                try {
                    String str;
                    while ((str = this.errStream.readLine()) != null) {
                        sb.append(str).append("\n");
                    }
                }
                catch (IOException ex) {
                    this.copy.logError("File not found a second time.", ex);
                }
                this.copy.logError(sb.toString());
            }
            this.copy.markAsFinished(false);
            this.copy.notifyEnd();
            return true;
        }
        catch (JSchException e) {
            this.copy.logError("Could not reconnect sftp channel.", e);
            this.copy.markAsFinished(false);
            this.copy.notifyEnd();
            return true;
        }
        if (fileSize == this.targetSize) {
            this.releaseResources();
            this.copy.markAsFinished(true);
            this.copy.notifyEnd();
            return true;
        }
        return false;
    }

    @Override
    public int getID() {
        return this.copy.getId();
    }

    @Override
    public void releaseResources() {
        if (this.exec != null) {
            this.exec.disconnect();
        }
        if (this.sftp != null) {
            this.sftp.disconnect();
        }
    }

    @Override
    public void shutdown() {
        this.releaseResources();
        this.copy.setState(GOSCopy.GOSCopyState.FAILED);
    }

    @Override
    public String getType() {
        return "Complex";
    }
}

