/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils;

import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.gos.master.sshutils.SSHSession;
import java.util.Collection;
import java.util.HashMap;

public class SSHGlobalHostCollection {
    private final HashMap<String, SSHHost> hosts = new HashMap();

    public SSHHost getHost(String user, String hostname) {
        String key = user + "@" + hostname;
        if (this.hosts.containsKey(key)) {
            return this.hosts.get(key);
        }
        return this.createHost(user, hostname);
    }

    private SSHHost createHost(String user, String hostname) {
        String key = user + "@" + hostname;
        SSHHost sshHost = new SSHHost(user, hostname);
        this.hosts.put(key, sshHost);
        return sshHost;
    }

    public void releaseAllResources() {
        for (SSHHost host : this.hosts.values()) {
            host.releaseAllResources();
        }
        this.hosts.clear();
    }

    public HashMap<String, Collection<SSHSession>> getAllSessions() {
        HashMap<String, Collection<SSHSession>> res = new HashMap<String, Collection<SSHSession>>();
        for (SSHHost h : this.hosts.values()) {
            String key = h.getFullHostName();
            Collection<SSHSession> value = h.getSessions();
            res.put(key, value);
        }
        return res;
    }

    public HashMap<String, Collection<SSHChannel>> getAllChannels() {
        HashMap<String, Collection<SSHChannel>> res = new HashMap<String, Collection<SSHChannel>>();
        for (SSHHost h : this.hosts.values()) {
            String key = h.getFullHostName();
            Collection<SSHChannel> value = h.getAllChannels();
            res.put(key, value);
        }
        return res;
    }
}

