/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.transfermonitor;

import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSGlobalTransferMonitor {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final ConcurrentHashMap<Integer, GOSTransferMonitor> activeTransfers = new ConcurrentHashMap();
    private static final String DBG_PREFIX = "[GOS Transfer Monitor]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferMonitor(GOSTransferMonitor m) {
        ConcurrentHashMap<Integer, GOSTransferMonitor> concurrentHashMap = this.activeTransfers;
        synchronized (concurrentHashMap) {
            this.activeTransfers.put(m.getID(), m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean monitor() {
        LOGGER.debug("[GOS Transfer Monitor]Monitoring GOS transfers");
        if (!this.existsActiveTransfers()) {
            LOGGER.debug("[GOS Transfer Monitor]No more active transfers");
            return false;
        }
        GOSTransferMonitor[] transfers = null;
        GOSTransferMonitor[] gOSTransferMonitorArray = this.activeTransfers;
        synchronized (this.activeTransfers) {
            Collection<GOSTransferMonitor> colTransfers = this.activeTransfers.values();
            if (!colTransfers.isEmpty()) {
                transfers = colTransfers.toArray(new GOSTransferMonitor[colTransfers.size()]);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (transfers != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[GOS Transfer Monitor]Transfers to monitor: " + transfers.length);
                }
                for (GOSTransferMonitor tm : transfers) {
                    if (!tm.monitor()) continue;
                    this.removeTransferMonitor(tm.getID());
                }
            }
            if (this.existsActiveTransfers()) {
                LOGGER.debug("[GOS Transfer Monitor]There are more active transfers. Keep running...");
                return true;
            }
            LOGGER.debug("[GOS Transfer Monitor]No more active transfers");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransferMonitor(int id) {
        ConcurrentHashMap<Integer, GOSTransferMonitor> concurrentHashMap = this.activeTransfers;
        synchronized (concurrentHashMap) {
            this.activeTransfers.remove(id);
        }
    }

    public boolean existsActiveTransfers() {
        return !this.activeTransfers.isEmpty();
    }

    public void end() {
        LOGGER.info("Ending global transfer monitor");
        for (GOSTransferMonitor tm : this.activeTransfers.values()) {
            tm.shutdown();
        }
        this.activeTransfers.clear();
    }
}

