/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.nio.ByteOrder;
import net.jpountz.util.Utils;

public enum SafeUtils {


    public static void checkRange(byte[] buf2, int off) {
        if (off < 0 || off >= buf2.length) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
    }

    public static void checkRange(byte[] buf2, int off, int len) {
        SafeUtils.checkLength(len);
        if (len > 0) {
            SafeUtils.checkRange(buf2, off);
            SafeUtils.checkRange(buf2, off + len - 1);
        }
    }

    public static void checkLength(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
    }

    public static byte readByte(byte[] buf2, int i) {
        return buf2[i];
    }

    public static int readIntBE(byte[] buf2, int i) {
        return (buf2[i] & 0xFF) << 24 | (buf2[i + 1] & 0xFF) << 16 | (buf2[i + 2] & 0xFF) << 8 | buf2[i + 3] & 0xFF;
    }

    public static int readIntLE(byte[] buf2, int i) {
        return buf2[i] & 0xFF | (buf2[i + 1] & 0xFF) << 8 | (buf2[i + 2] & 0xFF) << 16 | (buf2[i + 3] & 0xFF) << 24;
    }

    public static int readInt(byte[] buf2, int i) {
        if (Utils.NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            return SafeUtils.readIntBE(buf2, i);
        }
        return SafeUtils.readIntLE(buf2, i);
    }

    public static long readLongLE(byte[] buf2, int i) {
        return (long)buf2[i] & 0xFFL | ((long)buf2[i + 1] & 0xFFL) << 8 | ((long)buf2[i + 2] & 0xFFL) << 16 | ((long)buf2[i + 3] & 0xFFL) << 24 | ((long)buf2[i + 4] & 0xFFL) << 32 | ((long)buf2[i + 5] & 0xFFL) << 40 | ((long)buf2[i + 6] & 0xFFL) << 48 | ((long)buf2[i + 7] & 0xFFL) << 56;
    }

    public static void writeShortLE(byte[] buf2, int off, int v) {
        buf2[off++] = (byte)v;
        buf2[off++] = (byte)(v >>> 8);
    }

    public static void writeInt(int[] buf2, int off, int v) {
        buf2[off] = v;
    }

    public static int readInt(int[] buf2, int off) {
        return buf2[off];
    }

    public static void writeByte(byte[] dest, int off, int i) {
        dest[off] = (byte)i;
    }

    public static void writeShort(short[] buf2, int off, int v) {
        buf2[off] = (short)v;
    }

    public static int readShortLE(byte[] buf2, int i) {
        return buf2[i] & 0xFF | (buf2[i + 1] & 0xFF) << 8;
    }

    public static int readShort(short[] buf2, int off) {
        return buf2[off] & 0xFFFF;
    }
}

