/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.jobmonitor;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.GOSWorkerNode;
import es.bsc.compss.gos.master.exceptions.GOSWarningException;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostsManager;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSHostBatchMonitor
implements GOSHostsManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String CHECK_COMMAND_SCRIPT = GOSJob.SCRIPT_PATH + "check.sh";
    private final String installDir;
    final ConcurrentHashMap<String, GOSSingleBatchJobManager> activeJobs = new ConcurrentHashMap();
    HashSet<String> failedResponse = new HashSet();
    String responseDir;
    SSHHost host;

    GOSHostBatchMonitor(GOSJob job) {
        this.addJobMonitor(job);
        this.responseDir = job.getResponseDir();
        this.host = job.getSSHHost();
        this.installDir = ((GOSWorkerNode)job.getResourceNode()).getConfig().getInstallDir();
        assert (this.host != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void monitor() {
        if (this.activeJobs.isEmpty()) {
            return;
        }
        GOSSingleBatchJobManager[] jobs = null;
        ConcurrentHashMap<String, GOSSingleBatchJobManager> concurrentHashMap = this.activeJobs;
        // MONITORENTER : concurrentHashMap
        GOSSingleBatchJobManager[] col = this.activeJobs.values();
        if (!col.isEmpty()) {
            jobs = col.toArray(new GOSSingleBatchJobManager[col.size()]);
        }
        // MONITOREXIT : concurrentHashMap
        if (jobs == null) {
            return;
        }
        StringBuilder jobsId = new StringBuilder();
        for (GOSSingleBatchJobManager jm : jobs) {
            ConcurrentHashMap<String, GOSSingleBatchJobManager> concurrentHashMap2;
            GOSJob job = jm.getGosJob();
            if (job.isBeingCancelled()) {
                job.notifyFailure(JobEndStatus.EXECUTION_FAILED);
                concurrentHashMap2 = this.activeJobs;
                // MONITORENTER : concurrentHashMap2
                this.activeJobs.remove(jm.getId());
                // MONITOREXIT : concurrentHashMap2
                break;
            }
            if (job.getHistory() == JobHistory.CANCELLED) {
                LOGGER.error("Ignoring notification since the job was cancelled");
                concurrentHashMap2 = this.activeJobs;
                // MONITORENTER : concurrentHashMap2
                this.activeJobs.remove(jm.getId());
                // MONITOREXIT : concurrentHashMap2
                break;
            }
            jobsId.append(jm.getId()).append(" ");
            SSHChannel channel = job.getChannel();
            if (channel == null || !channel.isConnected() || channel.getExitStatus() == -1) continue;
            channel.disconnect();
            job.setChannel(null);
        }
        if (jobsId.toString().isEmpty()) {
            return;
        }
        String command = this.installDir + CHECK_COMMAND_SCRIPT + " " + this.responseDir + " " + jobsId;
        try {
            BufferedReader reader = this.host.executeCommand(command);
            while (reader.ready()) {
                boolean finished;
                String[] line = reader.readLine().split(" ");
                if (line.length < 3 || !(finished = this.treatJob(line[0], line[1], line[2]))) continue;
                ConcurrentHashMap<String, GOSSingleBatchJobManager> concurrentHashMap3 = this.activeJobs;
                // MONITORENTER : concurrentHashMap3
                this.activeJobs.remove(line[0]);
                // MONITOREXIT : concurrentHashMap3
            }
            return;
        }
        catch (JSchException | SftpException | IOException e) {
            LOGGER.error("Error in batch job monitor " + e);
            ErrorManager.error(e);
            return;
        }
        catch (GOSWarningException e) {
            LOGGER.warn("Warning in batch job monitor " + e.getLocalizedMessage());
        }
    }

    private boolean treatJob(String id, String batchId, String status) throws JSchException, SftpException, IOException {
        GOSSingleBatchJobManager jm = this.activeJobs.get(id);
        if (jm == null) {
            return false;
        }
        GOSJob job = jm.getGosJob();
        boolean finished = false;
        String batchOutput = job.getBatchOutput();
        String jobID = job.getCompositeID();
        switch (status) {
            case "END": {
                finished = true;
                job.setBatchId(batchId);
                job.notifySuccess();
                break;
            }
            case "CANCEL": 
            case "FAIL": {
                finished = true;
                job.setBatchId(batchId);
                job.notifyFailure(JobEndStatus.EXECUTION_FAILED);
                break;
            }
            case "SUBMIT": 
            case "LAUNCH": 
            case "RUN": {
                break;
            }
            default: {
                if (this.failedResponse.contains(id)) {
                    this.failedResponse.remove(id);
                    job.notifyFailure(JobEndStatus.SUBMISSION_FAILED);
                    break;
                }
                this.failedResponse.add(id);
            }
        }
        if (finished) {
            ArrayList<String> srcFiles = new ArrayList<String>();
            ArrayList<String> dstFiles = new ArrayList<String>();
            srcFiles.add(batchOutput + ".out");
            dstFiles.add(File.separator + GOSJob.JOBS_DIR + jobID + ".out");
            srcFiles.add(batchOutput + ".err");
            dstFiles.add(File.separator + GOSJob.JOBS_DIR + jobID + ".err");
            this.host.appendFiles(srcFiles, dstFiles);
        }
        return finished;
    }

    @Override
    public void addJobMonitor(GOSJob job) {
        this.activeJobs.put(job.getCompositeID(), new GOSSingleBatchJobManager(job));
    }

    @Override
    public int countActiveJobs() {
        return this.activeJobs.size();
    }

    @Override
    public boolean existsRunningJobs() {
        return !this.activeJobs.isEmpty();
    }

    @Override
    public void shutdown() {
        for (GOSSingleBatchJobManager jm : this.activeJobs.values()) {
            GOSJob job = jm.getGosJob();
            try {
                job.cancelJob();
            }
            catch (Exception e) {
                LOGGER.warn("Error cancelling job when shutdown. Ignoring.");
            }
        }
        this.activeJobs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJobMonitor(GOSJob job) {
        ConcurrentHashMap<String, GOSSingleBatchJobManager> concurrentHashMap = this.activeJobs;
        synchronized (concurrentHashMap) {
            this.activeJobs.remove(job.getCompositeID());
        }
    }

    private class GOSSingleBatchJobManager {
        private final GOSJob gosJob;
        private final String id;

        public GOSSingleBatchJobManager(GOSJob job) {
            this.gosJob = job;
            this.id = job.getCompositeID();
        }

        public GOSJob getGosJob() {
            return this.gosJob;
        }

        public String getId() {
            return this.id;
        }
    }
}

