/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class MultiNodeDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 3;
    private String declaringClass;
    private String methodName;
    private int ppn = 1;

    public MultiNodeDefinition() {
    }

    public MultiNodeDefinition(String methodClass, String methodName, int ppn) {
        this.declaringClass = methodClass;
        this.methodName = methodName;
        this.ppn = ppn;
    }

    public MultiNodeDefinition(String[] implTypeArgs, int offset) {
        this.declaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.methodName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        if (this.declaringClass == null || this.declaringClass.isEmpty()) {
            throw new IllegalArgumentException("Empty declaringClass annotation for method ");
        }
        if (this.methodName == null || this.methodName.isEmpty()) {
            throw new IllegalArgumentException("Empty methodName annotation for method ");
        }
        String ppnStr = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.ppn = ppnStr == null || ppnStr.isEmpty() ? 1 : Integer.parseInt(ppnStr);
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.declaringClass);
        lArgs.add(this.methodName);
        lArgs.add(Integer.toString(this.ppn));
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public int getPPN() {
        return this.ppn;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.MULTI_NODE;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[DECLARING CLASS=").append(this.declaringClass);
        sb.append(", METHOD NAME=").append(this.methodName);
        sb.append(", PPN=").append(this.ppn);
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MultiNode Implementation \n");
        sb.append("\t Class: ").append(this.declaringClass).append("\n");
        sb.append("\t Name: ").append(this.methodName).append("\n");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return " Multi-Node Method declared in class " + this.declaringClass + "." + this.methodName;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declaringClass = (String)in.readObject();
        this.methodName = (String)in.readObject();
        this.ppn = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declaringClass);
        out.writeObject(this.methodName);
        out.writeInt(this.ppn);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }
}

