/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.transfermonitor;

import es.bsc.compss.gos.master.GOSCopy;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.sftpmonitor.GOSJschTransferMonitor;
import es.bsc.compss.gos.master.sshutils.SSHChannel;

public class GOSOneWayTransferMonitor
implements GOSTransferMonitor {
    private final GOSJschTransferMonitor transferMonitor;
    private final SSHChannel channel;
    int id;
    GOSCopy copy;

    public GOSOneWayTransferMonitor(GOSCopy copy, GOSJschTransferMonitor monitor, SSHChannel channelSftp) {
        this.id = copy.getId();
        this.copy = copy;
        this.transferMonitor = monitor;
        this.channel = channelSftp;
    }

    @Override
    public boolean monitor() {
        if (this.transferMonitor.finished) {
            this.releaseResources();
            this.copy.markAsFinished(this.transferMonitor.success);
            this.copy.notifyEnd();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "GOSSimpleTransferMonitor_forCopy" + this.id;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void releaseResources() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    @Override
    public void shutdown() {
        this.releaseResources();
        this.copy.setState(GOSCopy.GOSCopyState.FAILED);
    }

    @Override
    public String getType() {
        return "ONE Way Transfer";
    }
}

