/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.ImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class HTTPDefinition
implements ImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 8;
    private String serviceName;
    private String resource;
    private String request;
    private String payload;
    private String payloadType;
    private String produces;
    private String updates;
    private String defReturn;

    public HTTPDefinition() {
    }

    public HTTPDefinition(String serviceName, String resource, String request, String payload, String payloadType, String produces, String updates, String defReturn) {
        this.serviceName = serviceName;
        this.resource = resource;
        this.request = request;
        this.payload = payload;
        this.payloadType = payloadType;
        this.produces = produces;
        this.updates = updates;
        this.defReturn = defReturn;
    }

    public HTTPDefinition(String[] implTypeArgs, int offset) {
        this.serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.resource = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.request = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.payload = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 3]);
        this.payloadType = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 4]);
        this.produces = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 5]);
        this.updates = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 6]);
        this.defReturn = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 7]);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResource() {
        return this.resource;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getPayloadType() {
        return this.payloadType;
    }

    public String getProduces() {
        return this.produces;
    }

    public String getUpdates() {
        return this.updates;
    }

    public String getDefReturn() {
        return this.defReturn;
    }

    public String toString() {
        return "HTTP Definition \n\t ServiceName: " + this.serviceName + "\n\t HTTP resource: " + this.resource + "\n";
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.HTTP;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.request = (String)in.readObject();
        this.resource = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.request);
        out.writeObject(this.resource);
    }

    @Override
    public String toShortFormat() {
        return " HTTP method type: " + this.request + " with base URL: " + this.resource;
    }
}

