/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.xxhash;

import java.nio.ByteBuffer;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.SafeUtils;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import net.jpountz.xxhash.XXHashJNI;

final class XXHash64JNI
extends XXHash64 {
    public static final XXHash64 INSTANCE = new XXHash64JNI();
    private static XXHash64 SAFE_INSTANCE;

    XXHash64JNI() {
    }

    @Override
    public long hash(byte[] buf2, int off, int len, long seed) {
        SafeUtils.checkRange(buf2, off, len);
        return XXHashJNI.XXH64(buf2, off, len, seed);
    }

    @Override
    public long hash(ByteBuffer buf2, int off, int len, long seed) {
        if (buf2.isDirect()) {
            ByteBufferUtils.checkRange(buf2, off, len);
            return XXHashJNI.XXH64BB(buf2, off, len, seed);
        }
        if (buf2.hasArray()) {
            return this.hash(buf2.array(), off + buf2.arrayOffset(), len, seed);
        }
        XXHash64 safeInstance = SAFE_INSTANCE;
        if (safeInstance == null) {
            safeInstance = SAFE_INSTANCE = XXHashFactory.safeInstance().hash64();
        }
        return safeInstance.hash(buf2, off, len, seed);
    }
}

