/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring;

import es.bsc.compss.gos.master.GOSAdaptor;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.monitoring.GOSMonitoringThread;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSGlobalJobMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSGlobalTransferMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSMonitoring {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final int SLEEP_TIME = 350;
    public Boolean awaken = false;
    private final GOSGlobalTransferMonitor globalTransferMonitor;
    private final GOSGlobalJobMonitor globalJobMonitor;
    public Boolean running = true;
    private final GOSAdaptor adaptor;
    public boolean shutdown = false;
    private Thread monitoringThread;

    public GOSMonitoring(GOSAdaptor adaptor) {
        this.adaptor = adaptor;
        this.globalTransferMonitor = new GOSGlobalTransferMonitor();
        this.globalJobMonitor = new GOSGlobalJobMonitor();
    }

    private boolean monitoringActiveJobs() {
        return this.globalJobMonitor.monitor();
    }

    private boolean monitoringActiveTransfers() {
        return this.globalTransferMonitor.monitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean monitoringJobsAndTransfers() {
        boolean ret;
        GOSMonitoring gOSMonitoring = this;
        synchronized (gOSMonitoring) {
            ret = this.monitoringActiveTransfers();
            ret = ret || this.monitoringActiveJobs();
        }
        return this.running != false && ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobMonitor(GOSJob job) {
        GOSMonitoring gOSMonitoring = this;
        synchronized (gOSMonitoring) {
            this.globalJobMonitor.addJobMonitor(job);
            if (!this.awaken.booleanValue()) {
                this.awakenMonitoring();
            }
        }
    }

    public void removeJobMonitor(GOSJob job) {
        this.globalJobMonitor.removeJobMonitor(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferMonitor(GOSTransferMonitor monitor) {
        GOSMonitoring gOSMonitoring = this;
        synchronized (gOSMonitoring) {
            this.globalTransferMonitor.addTransferMonitor(monitor);
            if (!this.awaken.booleanValue()) {
                this.awakenMonitoring();
            }
        }
    }

    private void awakenMonitoring() {
        LOGGER.info("[GOSMonitoring] awaking monitoring jobs");
        this.awaken = true;
        GOSMonitoringThread thread = new GOSMonitoringThread(this, 350);
        LOGGER.info("[GOSMonitoring] Monitoring AWAKEN");
        this.monitoringThread = new Thread(thread);
        this.monitoringThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        this.shutdown = true;
        GOSMonitoring gOSMonitoring = this;
        synchronized (gOSMonitoring) {
            this.globalJobMonitor.end();
            this.globalTransferMonitor.end();
            this.running = false;
        }
        if (this.monitoringThread != null) {
            this.monitoringThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dormant() {
        GOSMonitoring gOSMonitoring = this;
        synchronized (gOSMonitoring) {
            this.awaken = false;
            LOGGER.info("Monitoring thread going dormant");
        }
    }

    public boolean isMonitoringThreadAlive() {
        if (this.monitoringThread == null) {
            return false;
        }
        return this.monitoringThread.isAlive();
    }
}

