/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.external.piped.commands;

import es.bsc.compss.executor.external.commands.AddedExecutorExternalCommand;
import es.bsc.compss.executor.external.commands.ExternalCommand;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;

public class AddedExecutorPipeCommand
extends AddedExecutorExternalCommand
implements PipeCommand {
    private boolean success;
    private final String inPipe;
    private final String outPipe;
    private int pid;

    public AddedExecutorPipeCommand(String[] line) {
        this.success = line[0].compareTo(ExternalCommand.CommandType.ADDED_EXECUTOR.toString()) == 0;
        this.inPipe = line[1];
        this.outPipe = line[2];
        this.pid = Integer.parseInt(line[3]);
    }

    public AddedExecutorPipeCommand(PipePair pp) {
        this.success = false;
        this.inPipe = pp.getInboundPipe();
        this.outPipe = pp.getOutboundPipe();
    }

    @Override
    public String getAsString() {
        return super.getAsString() + " " + this.inPipe + " " + this.outPipe + (this.success ? " PID " + this.pid : " FAILED");
    }

    @Override
    public int compareTo(PipeCommand t) {
        int value = Integer.compare(this.getType().ordinal(), t.getType().ordinal());
        if (value == 0) {
            value = this.inPipe.compareTo(((AddedExecutorPipeCommand)t).inPipe);
        }
        if (value == 0) {
            value = this.outPipe.compareTo(((AddedExecutorPipeCommand)t).outPipe);
        }
        return value;
    }

    @Override
    public void join(PipeCommand receivedCommand) {
        this.success = ((AddedExecutorPipeCommand)receivedCommand).success;
        this.pid = ((AddedExecutorPipeCommand)receivedCommand).pid;
    }

    public int getPid() {
        return this.pid;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

