/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master;

import com.jcraft.jsch.JSchException;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.gos.master.GOSJobDescription;
import es.bsc.compss.gos.master.GOSWorkerNode;
import es.bsc.compss.gos.master.configuration.GOSConfiguration;
import es.bsc.compss.gos.master.monitoring.GOSMonitoring;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.exceptions.LangNotDefinedException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobImpl;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;

public class GOSJob
extends JobImpl<GOSWorkerNode> {
    public static final String SCRIPT_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "gos" + File.separator;
    private static final String WORKER_SCRIPT_NAME_BATCH = "queues" + File.separator + "submitBatch.sh";
    private static final String WORKER_SCRIPT_NAME_INTERACTIVE = "worker.sh";
    public static final String JOBS_DIR = System.getProperty("compss.log.dir") + "jobs" + File.separator;
    private static final boolean IS_STORAGE_ENABLED = System.getProperty("compss.storage.conf") != null && !System.getProperty("compss.storage.conf").equals("") && !System.getProperty("compss.storage.conf").equals("null");
    private static final String STORAGE_CONF = IS_STORAGE_ENABLED ? System.getProperty("compss.storage.conf") : "null";
    private static final String PYTHON_INTERPRETER = System.getProperty("compss.python.interpreter") != null ? System.getProperty("compss.python.interpreter") : "python3";
    private static final String PYTHON_VERSION = System.getProperty("compss.python.version") != null ? System.getProperty("compss.python.version") : "3";
    private static final String PYTHON_VIRTUAL_ENVIRONMENT = System.getProperty("compss.python.virtualenvironment") != null ? System.getProperty("compss.python.virtualenvironment") : "null";
    private static final String PYTHON_PROPAGATE_VIRTUAL_ENVIRONMENT = System.getProperty("compss.python.propagate_virtualenvironment") != null ? System.getProperty("compss.python.propagate_virtualenvironment") : "true";
    private static final String PYTHON_CUSTOM_EXTRAE_FILE = System.getProperty("compss.extrae.file.python") != null ? System.getProperty("compss.extrae.file.python") : "null";
    private GOSJobDescription jobDescription;
    private final ArrayList<String> slaveWorkersNodeNames;
    private SSHChannel channel;
    public String jobPrefix;
    private String batchId = "UNASSIGNED";

    public GOSJob(int taskId, TaskDescription task, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, task, impl, res, listener, predecessors, numSuccessors);
        this.slaveWorkersNodeNames = (ArrayList)slaveWorkersNodeNames;
        this.jobPrefix = "[GOSJob " + this.getCompositeID() + "] ";
    }

    public String getCompositeID() {
        return "task" + this.getTaskId() + "_job" + this.getJobId() + "_" + (Object)((Object)this.getHistory());
    }

    public GOSJobDescription getJobDescription() {
        return this.jobDescription;
    }

    @Override
    public void submitJob() {
        this.jobPrefix = "[GOSJob " + this.getCompositeID() + "] ";
        LOGGER.info("Submit GOSJob " + this.getCompositeID());
        this.jobDescription = this.prepareJob();
        String executable = this.getConfig().getInstallDir() + SCRIPT_PATH;
        if (this.isBatch()) {
            this.setCommandArgsBatch(this.jobDescription);
            executable = executable + WORKER_SCRIPT_NAME_BATCH;
        } else {
            executable = executable + WORKER_SCRIPT_NAME_INTERACTIVE;
        }
        this.jobDescription.setExecutable(executable);
        boolean correctlySubmitted = this.launchJob();
        if (!correctlySubmitted) {
            return;
        }
        this.addJobMonitor();
        ((GOSWorkerNode)this.getResourceNode()).addRunningJob(this);
        if (DEBUG) {
            LOGGER.debug("Ready to submit job " + this.jobId + ":");
            LOGGER.debug("  * user: " + this.getConfig().getUser());
            LOGGER.debug("  * Host: " + this.getConfig().getHost());
            LOGGER.debug("  * Batch: " + this.isBatch());
            if (this.isBatch()) {
                LOGGER.debug("      * Queues: " + this.jobDescription.getQueues());
                LOGGER.debug("      * MaxExecTime: " + this.jobDescription.getMaxExecTime());
                LOGGER.debug("      * QOS: " + this.jobDescription.getQOS());
                LOGGER.debug("      * CFG: " + this.jobDescription.getCFG());
            }
            LOGGER.debug("  * Executable: " + this.jobDescription.getExecutable());
            StringBuilder sb = new StringBuilder("  - Arguments:");
            for (String arg : this.jobDescription.getArguments()) {
                sb.append(" ").append(arg);
            }
            LOGGER.debug(sb.toString());
        }
    }

    private boolean launchJob() {
        boolean ret;
        try {
            SSHChannel ch = this.isBatch() ? this.launchJobBatch() : this.launchJobInteractive();
            this.setChannel(ch);
            ret = true;
        }
        catch (JSchException e) {
            LOGGER.error(this.jobPrefix + "Could not correctly submit.", (Throwable)e);
            this.notifyFailure(JobEndStatus.SUBMISSION_FAILED);
            ret = false;
        }
        return ret;
    }

    private GOSJobDescription prepareJob() {
        GOSJobDescription jd = new GOSJobDescription(this);
        if (this.isBatch()) {
            jd.setQueueType((ArrayList)this.getConfig().getProjectProperty("Queue"));
            jd.setCFG(this.getConfig().getProjectProperty("FileCFG"));
            jd.setQOS(this.getConfig().getProjectProperty("QOS"));
            jd.setReservation(this.getConfig().getProjectProperty("Reservation"));
            jd.setMaxExecTime(this.getConfig().getProjectProperty("MaxExecTime"));
        }
        jd.setHost(((GOSWorkerNode)this.getResourceNode()).getSSHHost());
        jd.setSandboxDir(this.getConfig().getSandboxWorkingDir());
        jd.setID(this.getCompositeID());
        try {
            jd.addOutput(File.separator + JOBS_DIR + this.getCompositeID() + ".out", File.separator + JOBS_DIR + this.getCompositeID() + ".err");
        }
        catch (IOException e) {
            LOGGER.error(this.jobPrefix + "Could not create output files.");
        }
        this.createArguments(jd);
        return jd;
    }

    private SSHChannel launchJobInteractive() throws JSchException {
        SSHChannel ch = this.getSSHHost().executeCommandInteractive(this.jobDescription);
        ch.reason = this.getCompositeID() + "launchJob";
        return ch;
    }

    private SSHChannel launchJobBatch() throws JSchException {
        return this.getSSHHost().executeCommandBatch(this.jobDescription);
    }

    private void addJobMonitor() {
        this.getGOSMonitoring().addJobMonitor(this);
    }

    private GOSMonitoring getGOSMonitoring() {
        return ((GOSWorkerNode)this.getResourceNode()).getGosMonitoring();
    }

    public SSHChannel getChannel() {
        return this.channel;
    }

    private GOSConfiguration getConfig() {
        return ((GOSWorkerNode)this.getResourceNode()).getConfig();
    }

    private void createArguments(GOSJobDescription jd) {
        LOGGER.debug("Preparing GOS Job " + this.jobId);
        jd.addArgument("taskIDComposite", this.getCompositeID());
        jd.addArgument("isBatch", String.valueOf(this.getConfig().isBatch()));
        jd.addArgument("responseDir", jd.getResponseFileDir());
        jd.addArgument("cancelScriptDir", jd.getCancelScriptDir());
        jd.addArgument("hostname", this.getHostName());
        jd.addArgument("installDir", this.getConfig().getInstallDir());
        jd.addArgument("appDir", this.getConfig().getAppDir());
        jd.addArgument("envScript", ((GOSWorkerNode)this.getResourceNode()).getEnvScriptPath());
        jd.addArgument("LibPath", ((GOSWorkerNode)this.getResourceNode()).getLibPath());
        jd.addArgument("workingDir-sandboxWorkingDir", this.getConfig().getSandboxWorkingDir());
        jd.addArgument("storageConf", STORAGE_CONF);
        jd.addArgument("streamingBackend", Comm.getStreamingBackend().name());
        jd.addArgument("appHost", Comm.getAppHost().getName());
        jd.addArgument("streamingPort", String.valueOf(Comm.getStreamingPort()));
        jd.addArgument("debug", String.valueOf(DEBUG));
        List<MultiURI> obsoleteFiles = this.getResource().pollObsoletes();
        if (obsoleteFiles != null) {
            jd.addArgument("numObsoleteFiles", String.valueOf(obsoleteFiles.size()));
            int i = 1;
            for (MultiURI u : obsoleteFiles) {
                jd.addArgument("obsoleteFile" + i++, u.getPath());
            }
        } else {
            jd.addArgument("numObsoleteFiles", "0");
        }
        jd.addArgument("tracing", Boolean.toString(Tracer.isActivated()));
        jd.addArgument("tracer runtime type", String.valueOf(TraceEventType.RUNTIME.code));
        jd.addArgument("sandbox creation id", String.valueOf(TraceEvent.CREATING_TASK_SANDBOX.getId()));
        jd.addArgument("sandbox removal id", String.valueOf(TraceEvent.REMOVING_TASK_SANDBOX.getId()));
        jd.addArgument("event type", String.valueOf(TraceEventType.TASKS_FUNC.code));
        jd.addArgument("tracer task id", String.valueOf(this.taskId));
        int slot = Tracer.isActivated() ? this.acquireTracingSlot() : -1;
        jd.addArgument("slot", String.valueOf(slot));
        jd.addArgument("PersistentC", "false");
        this.argumentsMethodImpl(jd, (AbstractMethodImplementation)this.impl);
        jd.addArgument("jobId", String.valueOf(this.jobId));
        jd.addArgument("taskId", String.valueOf(this.taskId));
        jd.addArgument("jobHistory", String.valueOf((Object)this.getHistory()));
        jd.addArgument("timeOut", String.valueOf(this.getTimeOut()));
        jd.addArgument("onFailure", String.valueOf((Object)this.getOnFailure()));
        jd.addArgument("n slaveWorkersNodeNames", "" + this.slaveWorkersNodeNames.size());
        for (int i = 0; i < this.slaveWorkersNodeNames.size(); ++i) {
            jd.addArgument("slaveWorker" + i, this.slaveWorkersNodeNames.get(i));
        }
        jd.addArgument("totalCPUComputingUnits", String.valueOf(((MethodResourceDescription)this.impl.getRequirements()).getTotalCPUComputingUnits()));
        jd.addArgument("cpuMap", "disabled");
        jd.addArgument("totalGPUComputingUnits", String.valueOf(((MethodResourceDescription)this.impl.getRequirements()).getTotalGPUComputingUnits()));
        jd.addArgument("gpuMap", "disabled");
        jd.addArgument("totalFPGAComputingUnits", String.valueOf(((MethodResourceDescription)this.impl.getRequirements()).getTotalFPGAComputingUnits()));
        jd.addArgument("fpgaMap", "disabled");
        int numReturns = this.taskParams.getNumReturns();
        int numParams = this.taskParams.getParameters().size();
        numParams -= numReturns;
        if (this.taskParams.hasTargetObject()) {
            --numParams;
        }
        jd.addArgument("numParams", Integer.toString(numParams));
        jd.addArgument("hasTargetObject", Boolean.toString(this.taskParams.hasTargetObject()));
        jd.addArgument("numReturns", Integer.toString(numReturns));
        this.processParameters(jd, this.taskParams.getParameters());
    }

    private void processParameters(GOSJobDescription jd, List<Parameter> parameters) {
        int i = 1;
        for (Parameter param : parameters) {
            LinkedList<String> singleParamDesc = new LinkedList<String>();
            DataType type = param.getType();
            singleParamDesc.add(Integer.toString(type.ordinal()));
            singleParamDesc.add(Integer.toString(param.getStream().ordinal()));
            String prefix = param.getPrefix();
            if (prefix == null || prefix.isEmpty()) {
                prefix = "null";
            }
            singleParamDesc.add(prefix);
            String paramName = param.getName();
            singleParamDesc.add(paramName == null ? "null" : (paramName.isEmpty() ? "null" : paramName));
            String conType = param.getContentType();
            singleParamDesc.add(conType == null ? "null" : (conType.isEmpty() ? "null" : conType));
            singleParamDesc.add(Double.toString(param.getWeight()));
            singleParamDesc.add(Boolean.toString(param.isKeepRename()));
            switch (type) {
                case FILE_T: 
                case EXTERNAL_STREAM_T: {
                    DependencyParameter dFilePar = (DependencyParameter)param;
                    String originalName = dFilePar.getOriginalName();
                    singleParamDesc.add(originalName);
                    singleParamDesc.add(dFilePar.getDataTarget());
                    break;
                }
                case PSCO_T: 
                case EXTERNAL_PSCO_T: {
                    LOGGER.error("GOS Adaptor does not support PSCO Types");
                    this.failed(JobEndStatus.SUBMISSION_FAILED);
                    break;
                }
                case OBJECT_T: 
                case STREAM_T: {
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    singleParamDesc.add(dPar.getDataTarget());
                    if (dAccId.isWrite()) {
                        singleParamDesc.add("W");
                        break;
                    }
                    singleParamDesc.add("R");
                    break;
                }
                case BINDING_OBJECT_T: {
                    DependencyParameter dExtObjPar = (DependencyParameter)param;
                    BindingObject bo = BindingObject.generate(dExtObjPar.getDataTarget());
                    singleParamDesc.add(bo.getId());
                    singleParamDesc.add(Integer.toString(bo.getType()));
                    singleParamDesc.add(Integer.toString(bo.getElements()));
                    break;
                }
                case STRING_T: {
                    BasicTypeParameter btParS = (BasicTypeParameter)param;
                    String value = btParS.getValue().toString();
                    int numSubStrings = value.split(" ").length;
                    singleParamDesc.add(Integer.toString(numSubStrings));
                    singleParamDesc.add(value);
                    break;
                }
                case STRING_64_T: {
                    BasicTypeParameter btp = (BasicTypeParameter)param;
                    byte[] decodedBytes = Base64.getDecoder().decode(btp.getValue().toString());
                    String[] values = new String(decodedBytes).split(" ");
                    singleParamDesc.add(Integer.toString(values.length));
                    singleParamDesc.addAll(Arrays.asList(values));
                    break;
                }
                default: {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    singleParamDesc.add(btParB.getValue().toString());
                }
            }
            jd.addArgument(singleParamDesc, "parameterDesc" + i++ + "_");
        }
    }

    private int acquireTracingSlot() {
        String host = this.getConfig().getHost();
        int slot = Tracer.getNextSlot(host);
        this.jobDescription.addTracingSlot(slot);
        return slot;
    }

    private void argumentsMethodImpl(GOSJobDescription jd, AbstractMethodImplementation absImpl) {
        COMPSsConstants.Lang lang = this.getLang();
        if (lang == COMPSsConstants.Lang.UNKNOWN) {
            throw new LangNotDefinedException();
        }
        jd.addArgument("lang", lang.toString().toLowerCase());
        jd.addArgument("taskSandboxWorkingDir", this.getConfig().getSandboxWorkingDir());
        jd.addArgument("javaClasspath", this.getClasspath());
        jd.addArgument("Pythonpath", this.getPythonpath());
        jd.addArgument("PYTHON_INTERPRETER", PYTHON_INTERPRETER);
        jd.addArgument("PYTHON_VERSION", PYTHON_VERSION);
        jd.addArgument("PYTHON_VIRTUAL_ENVIRONMENT", PYTHON_VIRTUAL_ENVIRONMENT);
        jd.addArgument("PYTHON_PROPAGATE_VIRTUAL_ENVIRONMENT", PYTHON_PROPAGATE_VIRTUAL_ENVIRONMENT);
        jd.addArgument("PYTHON_CUSTOM_EXTRAE_FILE", PYTHON_CUSTOM_EXTRAE_FILE);
        jd.addArgument("implType", String.valueOf((Object)absImpl.getMethodType()));
        int startImplementationArgs = jd.numArgs();
        switch (absImpl.getMethodType()) {
            default: {
                throw new RuntimeException("Not supported Method type: " + (Object)((Object)absImpl.getMethodType()));
            }
            case METHOD: {
                MethodDefinition methodImpl = (MethodDefinition)absImpl.getDefinition();
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName == null || methodName.isEmpty()) {
                    methodImpl.setAlternativeMethodName(this.taskParams.getName());
                }
                methodImpl.appendToArgs(jd.arguments, this.taskParams.getName());
                break;
            }
            case BINARY: {
                BinaryDefinition binaryImpl = (BinaryDefinition)absImpl.getDefinition();
                binaryImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case MPI: {
                MPIDefinition mpiImpl = (MPIDefinition)absImpl.getDefinition();
                mpiImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case COMPSs: {
                COMPSsDefinition compssImpl = (COMPSsDefinition)absImpl.getDefinition();
                compssImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case DECAF: {
                DecafDefinition decafImpl = (DecafDefinition)absImpl.getDefinition();
                decafImpl.appendToArgs(jd.arguments, ((GOSWorkerNode)this.getResourceNode()).getConfig().getAppDir());
                break;
            }
            case MULTI_NODE: {
                MultiNodeDefinition multiNodeImpl = (MultiNodeDefinition)absImpl.getDefinition();
                multiNodeImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case OMPSS: {
                OmpSsDefinition ompssImpl = (OmpSsDefinition)absImpl.getDefinition();
                ompssImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case OPENCL: {
                OpenCLDefinition openclImpl = (OpenCLDefinition)absImpl.getDefinition();
                openclImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case PYTHON_MPI: {
                PythonMPIDefinition pythonMPIImpl = (PythonMPIDefinition)absImpl.getDefinition();
                pythonMPIImpl.appendToArgs(jd.arguments, null);
                break;
            }
            case CONTAINER: {
                ContainerDefinition containerImpl = (ContainerDefinition)absImpl.getDefinition();
                containerImpl.appendToArgs(jd.arguments, null);
            }
        }
        jd.fillKeys("implementationArgument");
        int endImplementationArgs = jd.numArgs() - 1;
        jd.replaceIllegalCharacters(startImplementationArgs, endImplementationArgs);
    }

    @Override
    public void cancelJob() {
        LOGGER.debug("GOS Cancel Job " + this.getCompositeID());
        SSHHost executingHost = this.jobDescription.getSSHHost();
        String cancelScript = this.jobDescription.getCancelScriptDir() + "/" + this.getCompositeID();
        try {
            SSHChannel ch = executingHost.killJob(this, cancelScript, this.jobDescription.getOutput(), this.jobDescription.getOutputError());
            this.setChannel(ch);
        }
        catch (Exception e) {
            LOGGER.error(this.jobPrefix + " Error during job cancelation", (Throwable)e);
        }
    }

    public String getHostName() {
        return this.worker.getName();
    }

    @Override
    public TaskType getType() {
        return TaskType.METHOD;
    }

    @Override
    public String toString() {
        AbstractMethodImplementation method = (AbstractMethodImplementation)this.impl;
        String definition = method.getMethodDefinition();
        String methodName = this.taskParams.getName();
        return "GOSJob JobId" + this.jobId + " for method " + methodName + " with definition " + definition;
    }

    public String getResponseFile() {
        return this.jobDescription.getResponseFileDir() + File.separator + this.getCompositeID();
    }

    public String getResponseDir() {
        return this.jobDescription.getResponseFileDir();
    }

    public void notifySuccess() {
        LOGGER.info(this.jobPrefix + "Job done with success");
        ((GOSWorkerNode)this.getResourceNode()).removeRunningJob(this);
        this.completed();
    }

    @Override
    public void completed() {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        super.registerAllJobOutputsAsExpected();
        super.completed();
    }

    public void notifyFailure(JobEndStatus status) {
        LOGGER.error(this.jobPrefix + "Job produced an error");
        ((GOSWorkerNode)this.getResourceNode()).removeRunningJob(this);
        this.failed(status);
    }

    @Override
    public void failed(JobEndStatus status) {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        if (this.isBeingCancelled()) {
            super.registerAllJobOutputsAsExpected();
        }
        switch (this.taskParams.getOnFailure()) {
            case IGNORE: 
            case CANCEL_SUCCESSORS: {
                super.registerAllJobOutputsAsExpected();
                break;
            }
            default: {
                this.removeTmpData();
            }
        }
        super.failed(status);
    }

    public void setCommandArgsBatch(GOSJobDescription jd) {
        StringBuilder sb = new StringBuilder();
        sb.append(" --exec_time=").append(jd.getMaxExecTime());
        sb.append(" --sc_cfg=").append(jd.getCFG());
        sb.append(" --num_nodes=").append(this.taskParams.getNumNodes());
        sb.append(" --reservation=").append(jd.getReservation());
        sb.append(" --job_name=").append(this.getJobId());
        sb.append(" --qos=").append(jd.getQOS());
        MethodResourceDescription mrd = (MethodResourceDescription)this.impl.getRequirements();
        sb.append(" --cpus_per_node=").append(mrd.getTotalCPUComputingUnits());
        sb.append(" --gpus_per_node=").append(mrd.getTotalGPUComputingUnits());
        sb.append(" --fpgas_per_node=").append(mrd.getTotalFPGAComputingUnits());
        sb.append(" --job_name=").append(this.getJobId());
        sb.append(" --master_working_dir=").append(this.getConfig().getSandboxWorkingDir());
        String commandArgs = this.getConfig().getInstallDir() + SCRIPT_PATH + WORKER_SCRIPT_NAME_INTERACTIVE;
        sb.append(" ").append(commandArgs);
        jd.setCommandArgsBatch(sb.toString());
    }

    public void setChannel(SSHChannel ch) {
        this.channel = ch;
    }

    public SSHHost getSSHHost() {
        return this.getJobDescription().getSSHHost();
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public boolean isBatch() {
        return this.getConfig().isBatch();
    }

    public String getBatchOutput() {
        if (this.isBatch()) {
            return this.getConfig().getSandboxWorkingDir() + "BatchOutput" + "/" + this.getCompositeID();
        }
        return null;
    }
}

