/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring;

import es.bsc.compss.gos.master.GOSAdaptor;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.monitoring.GOSMonitoringThread;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSGlobalJobMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSGlobalTransferMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSMonitoring {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final int SLEEP_TIME = 350;
    public static AtomicBoolean awaken = new AtomicBoolean(false);
    private final GOSGlobalTransferMonitor globalTransferMonitor;
    private final GOSGlobalJobMonitor globalJobMonitor;
    public Boolean running = true;
    private final GOSAdaptor adaptor;
    public boolean shutdown = false;
    private Thread monitoringThread;

    public GOSMonitoring(GOSAdaptor adaptor) {
        this.adaptor = adaptor;
        this.globalTransferMonitor = new GOSGlobalTransferMonitor();
        this.globalJobMonitor = new GOSGlobalJobMonitor();
    }

    private boolean monitoringActiveJobs() {
        return this.globalJobMonitor.monitor();
    }

    private boolean monitoringActiveTransfers() {
        return this.globalTransferMonitor.monitor();
    }

    public boolean monitoringJobsAndTransfers() {
        boolean ret = this.monitoringActiveJobs();
        ret = ret || this.monitoringActiveTransfers();
        return this.running != false && ret;
    }

    public synchronized void addJobMonitor(GOSJob job) {
        this.globalJobMonitor.addJobMonitor(job);
        if (!awaken.get()) {
            this.awakenMonitoring();
        }
    }

    public void addTransferMonitor(GOSTransferMonitor monitor) {
        this.globalTransferMonitor.addTransferMonitor(monitor);
        if (!awaken.get()) {
            this.awakenMonitoring();
        }
    }

    private void awakenMonitoring() {
        LOGGER.info("[GOSMonitoring] awaking monitoring jobs");
        awaken.set(true);
        GOSMonitoringThread thread = new GOSMonitoringThread(this, 350);
        LOGGER.info("[GOSMonitoring] Monitoring AWAKEN");
        this.monitoringThread = new Thread(thread);
        this.monitoringThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        this.shutdown = true;
        GOSMonitoring gOSMonitoring = this;
        synchronized (gOSMonitoring) {
            this.globalJobMonitor.end();
            this.globalTransferMonitor.end();
            this.running = false;
        }
        if (this.monitoringThread != null) {
            this.monitoringThread.interrupt();
        }
    }

    public void dormant() {
        awaken.set(false);
        LOGGER.info("Monitoring thread going dormant");
    }

    public boolean isMonitoringThreadAlive() {
        if (this.monitoringThread == null) {
            return false;
        }
        return this.monitoringThread.isAlive();
    }
}

