/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.jobmonitor;

import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostBatchMonitor;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostsInteractiveManager;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostsManager;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSGlobalJobMonitor {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final HashMap<String, GOSHostsManager> hostsMonitor = new HashMap();

    public boolean monitor() {
        for (GOSHostsManager hm : this.hostsMonitor.values()) {
            hm.monitor();
        }
        return this.existsRunningJobs();
    }

    public void addJobMonitor(GOSJob job) {
        String hostID = job.getHostName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(job.jobPrefix + "Added job monitor");
        }
        if (!this.hostsMonitor.containsKey(hostID)) {
            if (job.isBatch()) {
                this.hostsMonitor.put(hostID, new GOSHostBatchMonitor(job));
            } else {
                this.hostsMonitor.put(hostID, new GOSHostsInteractiveManager(job));
            }
        } else {
            this.hostsMonitor.get(hostID).addJobMonitor(job);
        }
    }

    public boolean existsRunningJobs() {
        for (GOSHostsManager hm : this.hostsMonitor.values()) {
            if (!hm.existsRunningJobs()) continue;
            return true;
        }
        return false;
    }

    public void end() {
        for (GOSHostsManager hm : this.hostsMonitor.values()) {
            hm.shutdown();
        }
        this.hostsMonitor.clear();
    }
}

