/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.gos.master.GOSAdaptor;
import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.GOSJobDescription;
import es.bsc.compss.gos.master.exceptions.GOSWarningException;
import es.bsc.compss.gos.master.monitoring.transfermonitor.sftpmonitor.GOSJschTransferMonitor;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHSession;
import es.bsc.compss.gos.master.sshutils.SSHSessionManager;
import es.bsc.compss.gos.master.sshutils.staticmethods.SSHCommand;
import es.bsc.compss.gos.master.sshutils.staticmethods.SSHFileSystem;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHHost {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private final String dbgPrefix;
    JSch jsch = new JSch();
    private final String host;
    private final String username;
    private Integer port = 22;
    private final SSHSessionManager sessionManager;

    protected SSHHost(String user, String host) {
        if (user == null || user.isEmpty()) {
            LOGGER.warn("No username given defaulting to master user.");
            user = GOSAdaptor.getMasterUser();
        }
        this.host = host;
        this.username = user;
        this.dbgPrefix = "[SSHHost " + user + "@" + host + "] ";
        LOGGER.info(this.dbgPrefix + "Creating SSHost with user: " + user + " host: " + host);
        this.configJSCH();
        this.sessionManager = new SSHSessionManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHChannel openChannel(String type, String reason) throws JSchException {
        SSHChannel ch;
        SSHSessionManager sSHSessionManager = this.sessionManager;
        synchronized (sSHSessionManager) {
            ch = this.sessionManager.openChannel(type, reason);
        }
        return ch;
    }

    private void configJSCH() {
        ArrayList<String> possibleIdentityFiles = new ArrayList<String>();
        ArrayList<String> identityFiles = new ArrayList<String>();
        String homeDir = System.getProperty("user.home");
        possibleIdentityFiles.add(homeDir + "/.ssh/id_rsa");
        possibleIdentityFiles.add(homeDir + "/.ssh/id_ecdsa");
        for (String file : possibleIdentityFiles) {
            File f = new File(file);
            if (!f.exists()) continue;
            identityFiles.add(file);
        }
        if (identityFiles.isEmpty()) {
            String list = Arrays.toString(possibleIdentityFiles.toArray());
            ErrorManager.fatal("No identity found in any of theses locations: " + (String)list + ".");
            return;
        }
        try {
            this.jsch.setKnownHosts("~/.ssh/known_hosts");
            for (String file : identityFiles) {
                this.jsch.addIdentity(file);
            }
        }
        catch (JSchException e) {
            ErrorManager.fatal("Error in creating and configuring the SSHHost sessions", e);
        }
    }

    public String getUser() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public String getFullHostName() {
        return "ssh://" + this.username + "@" + this.host;
    }

    public SSHChannel executeCommandInteractive(GOSJobDescription jd) throws JSchException {
        return SSHCommand.executeCommand(jd);
    }

    public SSHChannel executeCommandBatch(GOSJobDescription jd) throws JSchException {
        return SSHCommand.executeCommandBatch(jd.getSSHHost(), jd, jd.getOutput(), jd.getOutputError());
    }

    public SSHChannel killJob(GOSJob job, String cancelScript, String outFile, String errFile) throws JSchException, FileNotFoundException {
        String pathResponse = job.getResponseFile();
        return SSHCommand.killJob(this, cancelScript, pathResponse, job, outFile, errFile);
    }

    public void executeStarterCommand(String command) throws InitNodeException {
        LOGGER.info(this.dbgPrefix + "Executing Start command " + command);
        try {
            SSHCommand.executeCommand(this, command);
        }
        catch (JSchException e) {
            LOGGER.warn(e);
            throw new InitNodeException(e);
        }
        catch (GOSWarningException e) {
            ErrorManager.warn(this.dbgPrefix + "Initialization command raised a non fatal error: " + e.getMessage() + ".");
        }
    }

    public void executeBlockingCommand(String command) throws JSchException, GOSWarningException {
        LOGGER.info(this.dbgPrefix + "Executing command " + command);
        SSHCommand.executeCommand(this, command);
    }

    public BufferedReader executeCommand(String command) throws JSchException, GOSWarningException {
        LOGGER.info(this.dbgPrefix + "Executing command " + command);
        return SSHCommand.executeCommand(this, command);
    }

    public void appendFiles(ArrayList<String> srcFiles, ArrayList<String> dstFiles) throws JSchException {
        assert (srcFiles.size() == dstFiles.size());
        for (int i = 0; i < srcFiles.size(); ++i) {
            try {
                SSHFileSystem.appendFile(this, srcFiles.get(i), dstFiles.get(i));
                continue;
            }
            catch (SftpException e) {
                ErrorManager.warn("Could not successfully bring " + srcFiles.get(i) + " skipping this file", e);
            }
        }
    }

    public void releaseAllResources() {
        this.sessionManager.releaseAllResources();
    }

    public Collection<SSHSession> getSessions() {
        return this.sessionManager.getSessions();
    }

    public Collection<SSHChannel> getAllChannels() {
        return this.sessionManager.getAllChannels();
    }

    public void removeFile(String path) throws JSchException, SftpException {
        SSHChannel ch = this.openChannel("sftp", "removeChannel");
        ch.delete(path);
        ch.disconnect();
    }

    public void getFile(String src, String dst) throws JSchException, SftpException {
        SSHChannel ch = this.openChannel("sftp", "getFile");
        ch.connect();
        ch.cd("/");
        GOSJschTransferMonitor monitor = new GOSJschTransferMonitor();
        try {
            ch.get(src, dst, monitor);
        }
        catch (SftpException e) {
            throw new RuntimeException(e);
        }
        while (!monitor.finished) {
            try {
                TimeUnit.MILLISECONDS.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ch.disconnect();
    }

    protected int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

