/*
 * Decompiled with CFR 0.152.
 */
package ibis.util;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPUtils {
    private static InetAddress[] addresses;

    private IPUtils() {
    }

    public static synchronized InetAddress[] getLocalHostAddresses() throws UnknownHostException {
        if (addresses == null) {
            addresses = IPUtils.getAllHostAddresses(true, true);
            if (addresses == null || addresses.length == 0) {
                addresses = IPUtils.getAllHostAddresses(false, true);
            }
            if (addresses == null || addresses.length == 0) {
                throw new UnknownHostException("could not determine addresseses for localhost");
            }
            Arrays.sort(addresses, new AddressSorter());
        }
        return (InetAddress[])addresses.clone();
    }

    public static InetAddress getLocalHostAddress() throws UnknownHostException {
        InetAddress[] addresses = IPUtils.getLocalHostAddresses();
        return addresses[0];
    }

    private static InetAddress[] getAllHostAddresses(boolean ignoreLoopback, boolean ignoreIP6) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                IPUtils.getAllHostAddresses(networkInterface, list, ignoreLoopback, ignoreIP6);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return list.toArray(new InetAddress[list.size()]);
    }

    private static void getAllHostAddresses(NetworkInterface nw, List<InetAddress> target, boolean ignoreLoopback, boolean ignoreIP6) {
        Enumeration<InetAddress> e2 = nw.getInetAddresses();
        while (e2.hasMoreElements()) {
            boolean t2;
            InetAddress tmp = e2.nextElement();
            boolean t1 = !ignoreLoopback || !tmp.isLoopbackAddress();
            boolean bl = t2 = !ignoreIP6 || tmp instanceof Inet4Address;
            if (!t1 || !t2) continue;
            target.add(tmp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddressSorter
    implements Comparator<InetAddress>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private AddressSorter() {
        }

        private int compareAddress(InetAddress i1, InetAddress i2, int score) {
            byte[] tmp2;
            byte[] tmp1 = i1.getAddress();
            if (tmp1.length != (tmp2 = i2.getAddress()).length) {
                return tmp2.length - tmp1.length;
            }
            for (int i = 0; i < tmp1.length; ++i) {
                if (tmp1[i] == tmp2[i]) continue;
                int t1 = tmp1[i] & 0xFF;
                int t2 = tmp2[i] & 0xFF;
                if (score == 4 && i == 0 && t1 == 192) {
                    return t1 - t2;
                }
                return t2 - t1;
            }
            return 0;
        }

        private int score(InetAddress ina) {
            if (ina.isLoopbackAddress()) {
                return 8;
            }
            if (ina.isLinkLocalAddress()) {
                return 6;
            }
            if (ina.isSiteLocalAddress()) {
                return 4;
            }
            return 2;
        }

        @Override
        public int compare(InetAddress i1, InetAddress i2) {
            int score1 = this.score(i1);
            int score2 = this.score(i2);
            int result = 0;
            result = score1 == score2 ? this.compareAddress(i1, i2, score1) : score1 - score2;
            return result;
        }
    }
}

