/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.data;

import es.bsc.compss.data.FetchDataListener;

public abstract class MultiOperationFetchListener
implements FetchDataListener {
    private int missingOperations = 0;
    private boolean enabled = false;
    private boolean error = false;
    private String failedDataId = null;
    private Exception failCause = null;

    public final synchronized void addOperation() {
        ++this.missingOperations;
    }

    public final int getMissingOperations() {
        return this.missingOperations;
    }

    public final synchronized void enable() {
        if (!this.enabled) {
            this.enabled = true;
            if (this.error) {
                this.doFailure(this.failedDataId, this.failCause);
            } else if (this.missingOperations == 0) {
                this.doCompleted();
            }
        }
    }

    @Override
    public final synchronized void fetchedValue(String fetchedDataId) {
        --this.missingOperations;
        if (this.enabled && !this.error && this.missingOperations == 0) {
            this.doCompleted();
        }
    }

    @Override
    public final synchronized void errorFetchingValue(String failedDataId, Exception cause) {
        --this.missingOperations;
        if (!this.error) {
            if (this.enabled) {
                this.error = true;
                this.doFailure(failedDataId, cause);
            } else {
                this.failedDataId = failedDataId;
                this.failCause = cause;
            }
        }
    }

    public abstract void doCompleted();

    public abstract void doFailure(String var1, Exception var2);
}

