/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.worker;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.gos.executor.types.ExecutionEnd;
import es.bsc.compss.gos.master.utils.ForbiddenCharacters;
import es.bsc.compss.gos.worker.GOSInvocation;
import es.bsc.compss.invokers.types.CParams;
import es.bsc.compss.invokers.types.JavaParams;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.types.ErrorHandler;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationExecutionRequest;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.NonExistentDataException;
import es.bsc.compss.types.execution.exceptions.UnloadableValueException;
import es.bsc.compss.types.execution.exceptions.UnwritableValueException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.util.serializers.Serializer;
import es.bsc.compss.utils.execution.ExecutionManager;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.distrostreamlib.client.DistroStreamClient;
import es.bsc.distrostreamlib.exceptions.DistroStreamClientInitException;
import es.bsc.distrostreamlib.requests.StopRequest;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class GOSWorker
implements InvocationContext {
    private static final String ERROR_STREAMING_INIT = "ERROR: Cannot load Streaming Client";
    private static final String ERROR_STREAMING_FINISH = "ERROR: Cannot stop Streaming Client";
    private static final String ERROR_STORAGE_CONF_INIT = "ERROR: Cannot load storage configuration file: ";
    private static final String ERROR_STORAGE_CONF_FINISH = "ERROR: Cannot stop StorageItf";
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    private static final String WARN_UNSUPPORTED_METHOD_TYPE = "WARNING: Unsupported method type";
    private static final int HOSTS_FLAGS_SIZE = 10;
    private static final int TRACING_FLAGS_SIZE = 7;
    private static final int LANG_SIZE_FLAGS = 10;
    private static final int EXTRA_FLAG_SIZE = 0;
    private static final int HOST_INX = 0;
    private static final int TRACING_INX = 10;
    private static final int LANG_INX = 17;
    private static final int EXTRA_FLAG_INX = 27;
    private static final int DEFAULT_FLAGS_SIZE = 27;
    private final String hostName;
    private final String appDir;
    private final String installDir;
    private final String workingDir;
    private final String storageConf;
    private final StreamBackend streamBackend;
    private final String streamMasterName;
    private final int streamMasterPort;
    private final ExecutionManager executionManager;
    private final boolean debug;
    private final boolean tracing;
    private final int tracingSlot;
    private final COMPSsConstants.Lang lang;
    private String[] tracingParams;
    private final LanguageParams[] langParams;
    private String envScriptPath;

    public static void main(String[] args) throws Exception {
        ForbiddenCharacters.init();
        ForbiddenCharacters.decode(args);
        int i = 0;
        boolean debug = Boolean.parseBoolean(args[0 + i++]);
        String workerName = args[0 + i++];
        String workingDir = args[0 + i++];
        String installDir = args[0 + i++];
        String appDir = args[0 + i++];
        String envScriptPath = args[0 + i++];
        String storageConfArg = args[0 + i++];
        String streamingArg = args[0 + i++];
        String streamMasterName = args[0 + i++];
        int streamMasterPort = Integer.parseInt(args[0 + i++]);
        boolean tracing = Boolean.parseBoolean(args[10]);
        String[] tracingParams = Arrays.copyOfRange(args, 11, 17);
        int tracingSlot = Integer.parseInt(args[16]);
        i = 0;
        boolean persistentC = Boolean.parseBoolean(args[17 + i++]);
        String lang = args[17 + i++];
        String taskSandboxWorkingDir = args[17 + i++];
        String classpath = args[17 + i++];
        String pythonpath = args[17 + i++];
        String pythonInterpreter = args[17 + i++];
        String pythonVersion = args[17 + i++];
        String pythonVirtualEnvironment = args[17 + i++];
        String pythonPropagateVirtualEnvironment = args[17 + i++];
        String pythonExtraeFile = args[17 + i++];
        String pythonMpiWorker = "null";
        String pythonWorkerCache = "null";
        String pythonCacheProfiler = "null";
        JavaParams javaParams = new JavaParams(classpath);
        PythonParams pyParams = new PythonParams(pythonInterpreter, pythonVersion, pythonVirtualEnvironment, pythonPropagateVirtualEnvironment, pythonpath, pythonExtraeFile, "null", "null", "null");
        CParams cParams = new CParams(classpath);
        LanguageParams[] langParams = new LanguageParams[COMPSsConstants.Lang.values().length];
        langParams[COMPSsConstants.Lang.JAVA.ordinal()] = javaParams;
        langParams[COMPSsConstants.Lang.PYTHON.ordinal()] = pyParams;
        langParams[COMPSsConstants.Lang.C.ordinal()] = cParams;
        ErrorHandler errorHandlerGOS = new ErrorHandler(){
            Logger log = LogManager.getLogger("es.bsc.compss.Components.ErrorManager");

            @Override
            public boolean handleError() {
                return this.handleFatalError();
            }

            @Override
            public boolean handleFatalError() {
                this.log.info("Shutting down remote COMPSs...");
                this.log.error("Error detected. Shutting down Remote Worker");
                System.exit(1);
                return true;
            }
        };
        ErrorManager.init(errorHandlerGOS);
        String streaming = streamingArg == null || streamingArg.isEmpty() || streamingArg.equals("null") ? "NONE" : streamingArg.toUpperCase();
        StreamBackend streamBackend = StreamBackend.valueOf(streaming);
        if (!streamBackend.equals((Object)StreamBackend.NONE)) {
            try {
                DistroStreamClient.initAndStart(streamMasterName, streamMasterPort);
            }
            catch (DistroStreamClientInitException dscie) {
                ErrorManager.fatal(ERROR_STREAMING_INIT, dscie);
            }
        }
        GOSInvocation implDef = GOSWorker.parseArguments(args, debug, COMPSsConstants.Lang.valueOf(lang.toUpperCase()));
        String storageConf = storageConfArg == null || storageConfArg.isEmpty() ? "null" : storageConfArg;
        System.setProperty("compss.storage.conf", storageConf);
        if (storageConf != null && !storageConf.equals("null")) {
            try {
                StorageItf.init(storageConf);
            }
            catch (StorageException se) {
                ErrorManager.fatal(ERROR_STORAGE_CONF_INIT + storageConf, se);
            }
        }
        GOSWorker worker = new GOSWorker(workerName, workingDir, debug, installDir, appDir, storageConf, streamBackend, streamMasterName, streamMasterPort, implDef.getComputingUnits(), implDef.getCPUMap(), implDef.getGPUComputingUnits(), implDef.getGPUMAp(), implDef.getFPGAUnits(), implDef.getFPGAMap(), tracing, tracingSlot, tracingParams, lang, langParams, envScriptPath);
        boolean success = worker.runTask(implDef);
        if (!streamBackend.equals((Object)StreamBackend.NONE)) {
            StopRequest stopRequest = new StopRequest();
            DistroStreamClient.request(stopRequest);
            stopRequest.waitProcessed();
            int errorCode = stopRequest.getErrorCode();
            if (errorCode != 0) {
                System.err.println(ERROR_STREAMING_FINISH);
                System.err.println("Error Code: " + errorCode);
                System.err.println("Error Message: " + stopRequest.getErrorMessage());
            }
        }
        if (storageConf != null && !storageConf.equals("null")) {
            try {
                StorageItf.finish();
            }
            catch (StorageException se) {
                System.err.println(ERROR_STORAGE_CONF_FINISH);
                se.printStackTrace();
            }
        }
        if (!success) {
            System.exit(7);
        }
    }

    public GOSWorker(String workerName, String workingDir, boolean debug, String installDir, String appDir, String storageConf, StreamBackend streamBackend, String streamMasterName, int streamMasterPort, int computingUnitsCPU, String cpuMap, int computingUnitsGPU, String gpuMap, int computingUnitsFPGA, String fpgaMap, boolean tracing, int tracingSlot, String[] tracingParams, String lang, LanguageParams[] langParams, String envScriptPath) {
        this.hostName = workerName;
        this.workingDir = workingDir;
        this.debug = debug;
        this.installDir = installDir;
        this.appDir = appDir;
        this.storageConf = storageConf;
        this.streamBackend = streamBackend;
        this.streamMasterName = streamMasterName;
        this.streamMasterPort = streamMasterPort;
        this.tracing = tracing;
        this.tracingParams = tracingParams;
        this.tracingSlot = tracingSlot;
        this.lang = COMPSsConstants.Lang.valueOf(lang.toUpperCase());
        this.langParams = langParams;
        this.envScriptPath = envScriptPath;
        this.executionManager = new ExecutionManager(this, computingUnitsCPU, cpuMap, false, computingUnitsGPU, gpuMap, computingUnitsFPGA, fpgaMap, 0, 1);
        if (debug) {
            System.out.println("Initializing ExecutionManager");
        }
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, ie);
        }
    }

    private static GOSInvocation parseArguments(String[] args, boolean debug, COMPSsConstants.Lang lang) {
        int argPosition = 27;
        MethodType methodType = MethodType.valueOf(args[argPosition++]);
        switch (methodType) {
            case METHOD: {
                return GOSWorker.genImplemenationDefinition(new MethodDefinition(args, argPosition), debug, args, argPosition + 2, lang);
            }
            case BINARY: {
                return GOSWorker.genImplemenationDefinition(new BinaryDefinition(args, argPosition), debug, args, argPosition + 4, lang);
            }
            case MPI: {
                String[] container = new String[3];
                return GOSWorker.genImplemenationDefinition(new MPIDefinition(args, argPosition, container), debug, args, argPosition + 8, lang);
            }
            case COMPSs: {
                return GOSWorker.genImplemenationDefinition(new COMPSsDefinition(args, argPosition), debug, args, argPosition + 6, lang);
            }
            case DECAF: {
                return GOSWorker.genImplemenationDefinition(new DecafDefinition(args, argPosition), debug, args, argPosition + 6, lang);
            }
            case MULTI_NODE: {
                return GOSWorker.genImplemenationDefinition(new MultiNodeDefinition(args, argPosition), debug, args, argPosition + 2, lang);
            }
            case OMPSS: {
                return GOSWorker.genImplemenationDefinition(new OmpSsDefinition(args, argPosition), debug, args, argPosition + 3, lang);
            }
            case OPENCL: {
                return GOSWorker.genImplemenationDefinition(new OpenCLDefinition(args, argPosition), debug, args, argPosition + 2, lang);
            }
            case PYTHON_MPI: {
                PythonMPIDefinition pyMPIDef = new PythonMPIDefinition(args, argPosition);
                return GOSWorker.genImplemenationDefinition(pyMPIDef, debug, args, argPosition + 10 + pyMPIDef.getCollectionLayouts().length * 4, lang);
            }
            case CONTAINER: {
                return GOSWorker.genImplemenationDefinition(new ContainerDefinition(args, argPosition), debug, args, argPosition + 9, lang);
            }
        }
        ErrorManager.error(WARN_UNSUPPORTED_METHOD_TYPE + (Object)((Object)methodType));
        return null;
    }

    private static GOSInvocation genImplemenationDefinition(AbstractMethodImplementationDefinition implDef, boolean debug, String[] args, int argPosition, COMPSsConstants.Lang lang) {
        ImplementationDescription<Object, AbstractMethodImplementationDefinition> implDesc = new ImplementationDescription<Object, AbstractMethodImplementationDefinition>(implDef, "", false, null, null, null);
        AbstractMethodImplementation impl = new AbstractMethodImplementation((Integer)0, (Integer)0, (ImplementationDescription<MethodResourceDescription, AbstractMethodImplementationDefinition>)implDesc);
        return new GOSInvocation(debug, lang, impl, args, argPosition);
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public long getTracingHostID() {
        return Integer.parseInt(this.tracingParams[this.tracingParams.length - 1]);
    }

    @Override
    public String getAppDir() {
        return this.appDir;
    }

    @Override
    public String getInstallDir() {
        return this.installDir;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public String getLogDir() {
        return this.workingDir;
    }

    @Override
    public PrintStream getThreadOutStream() {
        return System.out;
    }

    @Override
    public PrintStream getThreadErrStream() {
        return System.err;
    }

    @Override
    public COMPSsConstants.TaskExecution getExecutionType() {
        return COMPSsConstants.TaskExecution.COMPSS;
    }

    @Override
    public boolean isPersistentCEnabled() {
        return false;
    }

    @Override
    public LanguageParams getLanguageParams(COMPSsConstants.Lang lang) {
        return this.langParams[lang.ordinal()];
    }

    @Override
    public void registerOutputs(String outputsBasename) {
    }

    @Override
    public void unregisterOutputs() {
    }

    @Override
    public String getStandardStreamsPath(Invocation invocation) {
        return this.getWorkingDir() + "jobs" + File.separator + "job" + invocation.getJobId() + "_" + (Object)((Object)invocation.getHistory());
    }

    @Override
    public String getStorageConf() {
        return this.storageConf;
    }

    @Override
    public StreamBackend getStreamingBackend() {
        return this.streamBackend;
    }

    @Override
    public String getStreamingMasterName() {
        return this.streamMasterName;
    }

    @Override
    public int getStreamingMasterPort() {
        return this.streamMasterPort;
    }

    @Override
    public void loadParam(InvocationParam np) throws UnloadableValueException {
        switch (np.getType()) {
            case OBJECT_T: 
            case STREAM_T: {
                String fileLocation = (String)np.getValue();
                np.setOriginalName(fileLocation);
                try {
                    Object o = Serializer.deserialize(fileLocation);
                    np.setValue(o);
                    break;
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new UnloadableValueException(e);
                }
            }
            case PSCO_T: {
                String pscoId = (String)np.getValue();
                try {
                    StorageItf.getByID(pscoId);
                    break;
                }
                catch (StorageException se) {
                    throw new UnloadableValueException(se);
                }
            }
            case FILE_T: 
            case EXTERNAL_STREAM_T: 
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    @Override
    public void storeParam(InvocationParam np, boolean createifNonExistent) throws UnwritableValueException, NonExistentDataException {
        switch (np.getType()) {
            case FILE_T: {
                String filepath = (String)np.getValue();
                if (Tracer.isActivated()) {
                    Tracer.emitEvent(TraceEvent.CHECK_OUT_PARAM);
                }
                File f = new File(filepath);
                boolean fExists = f.exists();
                if (Tracer.isActivated()) {
                    Tracer.emitEventEnd(TraceEvent.CHECK_OUT_PARAM);
                }
                if (fExists) break;
                if (createifNonExistent) {
                    System.out.println("Creating new blank file at " + filepath);
                    try {
                        f.createNewFile();
                    }
                    catch (IOException e) {
                        if (this.debug) {
                            System.err.println("ERROR creating new blank file at " + filepath);
                        }
                        throw new UnwritableValueException(e);
                    }
                }
                throw new NonExistentDataException(filepath);
            }
            case OBJECT_T: 
            case STREAM_T: {
                String fileLocation = np.getOriginalName();
                System.out.println("Storing parameter " + np.getName() + " in " + fileLocation);
                try {
                    Serializer.serialize(np.getValue(), fileLocation);
                    break;
                }
                catch (IOException ioe) {
                    throw new UnwritableValueException(ioe);
                }
            }
            case PSCO_T: {
                throw new UnsupportedOperationException("Output PSCOs are not suported with the GAT adaptor");
            }
            case EXTERNAL_STREAM_T: 
            case BINDING_OBJECT_T: 
            case EXTERNAL_PSCO_T: {
                break;
            }
        }
    }

    private boolean runTask(GOSInvocation task) {
        final ExecutionEnd status = new ExecutionEnd();
        final Semaphore sem = new Semaphore(0);
        InvocationExecutionRequest.Listener listener = new InvocationExecutionRequest.Listener(){

            @Override
            public void onResultAvailable(InvocationParam param) {
            }

            @Override
            public void notifyEnd(Invocation invocation, boolean success, COMPSsException e) {
                status.setSuccess(success);
                sem.release();
            }
        };
        InvocationExecutionRequest e = new InvocationExecutionRequest(task, listener);
        this.executionManager.enqueue(e);
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.executionManager.stop();
        return status.getSuccess();
    }

    @Override
    public COMPSsRuntime getRuntimeAPI() {
        return null;
    }

    @Override
    public LoaderAPI getLoaderAPI() {
        return null;
    }

    @Override
    public void idleReservedResourcesDetected(ResourceDescription resources) {
    }

    @Override
    public void reactivatedReservedResourcesDetected(ResourceDescription resources) {
    }

    @Override
    public String getEnvironmentScript() {
        return this.envScriptPath;
    }
}

