/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master;

import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.gos.master.utils.ForbiddenCharacters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public class GOSJobDescription {
    private String pathResponse;
    public ArrayList<String> arguments = new ArrayList();
    private final ArrayList<String> argumentsKey = new ArrayList();
    public ArrayList<String> killArguments;
    private String executable;
    private String commandOptionsBatch;
    private SSHHost host;
    private String outputError;
    private String sandboxDir;
    private String id;
    private String output;
    private int tracingSlot;
    private ArrayList<String> queues;
    private String cfg;
    private String qos;
    private String projectName;
    private long maxExecTime;
    private String reservation;
    private String killDir;
    private GOSJob job;

    public String getHostname() {
        return this.host.getFullHostName();
    }

    public SSHHost getSSHHost() {
        return this.host;
    }

    public String getOutputError() {
        return this.outputError;
    }

    public String getOutput() {
        return this.output;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void setHost(SSHHost host) {
        this.host = host;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public GOSJobDescription(GOSJob gosJob) {
        this.job = gosJob;
        this.killArguments = new ArrayList();
        ForbiddenCharacters.init();
    }

    public ArrayList<String> getArguments() {
        return this.arguments;
    }

    public void addArgument(LinkedList<String> values, String message) {
        int i = 0;
        for (String v : values) {
            this.addArgument(message + i++, v);
        }
    }

    public void addArgument(String key, String value, boolean replaceSpace) {
        if (value == null || value.isEmpty() || value.equals("\"\"")) {
            value = "null";
        }
        if (key == null || key.isEmpty() || key.equals("\"\"")) {
            key = "key_not_given";
        }
        value = this.replaceIllegalCharacters(value, replaceSpace);
        this.argumentsKey.add(key);
        this.arguments.add(value);
    }

    public void addArgument(String key, String value) {
        this.addArgument(key, value, false);
    }

    public void replaceIllegalCharacters(int initialPosition, int finalPosition) {
        for (int i = initialPosition; i <= finalPosition; ++i) {
            String value;
            String oldValue = this.arguments.get(i);
            if (oldValue.equals(value = this.replaceIllegalCharacters(oldValue, true))) continue;
            this.arguments.set(i, value);
        }
    }

    private String replaceIllegalCharacters(String value, boolean replaceSpace) {
        return ForbiddenCharacters.encode(value, replaceSpace);
    }

    public void fillKeys(String fillMessage) {
        int diff = this.arguments.size() - this.argumentsKey.size();
        for (int i = 0; i < diff; ++i) {
            this.argumentsKey.add(fillMessage + i);
        }
    }

    public int numArgs() {
        return Math.min(this.arguments.size(), this.argumentsKey.size());
    }

    public String getArgKey(int x) {
        return this.argumentsKey.get(x);
    }

    public String getArg(int x) {
        return this.arguments.get(x);
    }

    public void addOutput(String out, String err) throws IOException {
        this.output = out;
        this.outputError = err;
        this.createOutputFiles();
    }

    public void addTracingSlot(int slot) {
        this.tracingSlot = slot;
    }

    private void createOutputFiles() throws IOException {
        File newFile = new File(this.output);
        newFile.createNewFile();
        newFile = new File(this.outputError);
        newFile.createNewFile();
    }

    public String getSandboxDir() {
        return this.sandboxDir;
    }

    public void setSandboxDir(String sandboxDir) {
        this.sandboxDir = sandboxDir;
    }

    public String getResponseFileDir() {
        if (this.pathResponse == null) {
            this.pathResponse = this.getSandboxDir() + "JobsStatus";
        }
        return this.pathResponse;
    }

    public String getCancelScriptDir() {
        if (this.killDir == null) {
            this.killDir = this.getSandboxDir() + "CancelJobsScript";
        }
        return this.killDir;
    }

    public String getCancelScript(String compositeID) {
        String script = this.getCancelScriptDir() + "/" + compositeID;
        if (!this.killArguments.isEmpty()) {
            script = script + " " + StringUtils.join(this.killArguments, " ");
        }
        return script;
    }

    public void setQueueType(ArrayList<String> queues) {
        this.queues = queues;
    }

    public ArrayList<String> getQueues() {
        return this.queues;
    }

    public void setCFG(Object fileCFG) {
        String t = (String)fileCFG;
        this.cfg = fileCFG == null || t.isEmpty() || t.equals("null") ? "" : t;
    }

    public String getCFG() {
        return this.cfg;
    }

    public void setQOS(Object qos) {
        String t = (String)qos;
        this.qos = qos == null || t.isEmpty() || t.equals("null") ? "false" : t;
    }

    public String getQOS() {
        return this.qos;
    }

    public void setProjectName(Object projectName) {
        String t = (String)projectName;
        this.projectName = projectName == null || t.isEmpty() || t.equals("null") ? "" : t;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setMaxExecTime(Object time) {
        Long t = (Long)time;
        this.maxExecTime = time == null || t < 1L ? 30L : t;
    }

    public long getMaxExecTime() {
        return this.maxExecTime;
    }

    public void setReservation(Object reservation) {
        String r = (String)reservation;
        this.reservation = reservation == null || r.isEmpty() || r.equals("null") ? "disabled" : r;
    }

    public String getReservation() {
        return this.reservation;
    }

    public void setCommandArgsBatch(String args) {
        this.commandOptionsBatch = args;
    }

    public String getCommandArgsBatch() {
        return this.commandOptionsBatch;
    }

    public String getArgumentsString() {
        String args = StringUtils.join(this.arguments, " ");
        return args;
    }
}

