/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class MethodDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 2;
    private String declaringClass;
    private String alternativeMethod;

    public MethodDefinition() {
    }

    public MethodDefinition(String methodClass, String altMethodName) {
        this.declaringClass = methodClass;
        this.alternativeMethod = altMethodName;
    }

    public MethodDefinition(String[] implTypeArgs, int offset) {
        this.declaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset]);
        this.alternativeMethod = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        if (this.declaringClass == null || this.declaringClass.isEmpty()) {
            throw new IllegalArgumentException("Empty declaringClass annotation for method " + this.alternativeMethod);
        }
        if (this.alternativeMethod == null || this.alternativeMethod.isEmpty()) {
            throw new IllegalArgumentException("Empty methodName annotation for method " + this.declaringClass);
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.declaringClass);
        lArgs.add(this.alternativeMethod);
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getAlternativeMethodName() {
        return this.alternativeMethod;
    }

    public void setAlternativeMethodName(String alternativeMethod) {
        this.alternativeMethod = alternativeMethod;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.METHOD;
    }

    @Override
    public String toJSON() {
        StringBuilder sb = new StringBuilder("{\"type\":\"METHOD\",");
        sb.append("\"declaring_class\":\"").append(this.declaringClass).append("\",");
        sb.append("\"method_name\":\"").append(this.alternativeMethod).append("\"");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return "Method declared in class " + this.declaringClass + "." + this.alternativeMethod + ": " + this.alternativeMethod;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.declaringClass = (String)in.readObject();
        this.alternativeMethod = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.declaringClass);
        out.writeObject(this.alternativeMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("METHOD Implementation \n");
        sb.append("\t Declaring class: ").append(this.declaringClass).append("\n");
        sb.append("\t Method name: ").append(this.alternativeMethod).append("\n");
        return sb.toString();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }
}

