/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.utils;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class ForbiddenCharacters {
    private static final HashMap<String, String> encodeCharacters = new HashMap();
    private static final HashMap<String, String> decodeCharacters = new HashMap();
    private static boolean initalized = false;
    private static final String internalPrefix = "__Special";
    private static final String RESET = "\u001b[0m";
    private static final String RED = "\u001b[0;31m";
    private static final String GREEN = "\u001b[0;32m";

    public static void init() {
        String[] chars;
        if (initalized) {
            return;
        }
        initalized = true;
        for (String decodedChar : chars = new String[]{"$", "#", "--", "~", ";", "<", ">", "--", " "}) {
            String encodedChar = internalPrefix + new String(Base64.getEncoder().encode(decodedChar.getBytes()));
            encodeCharacters.put(decodedChar, encodedChar);
            decodeCharacters.put(encodedChar, decodedChar);
        }
    }

    public static String encode(String word, boolean replaceSpace) {
        for (Map.Entry<String, String> entry : encodeCharacters.entrySet()) {
            if (!replaceSpace && entry.getKey().equals(" ")) continue;
            word = word.replace(entry.getKey(), entry.getValue());
        }
        return word;
    }

    public static String decode(String word) {
        if (word.contains(internalPrefix)) {
            for (Map.Entry<String, String> entry : decodeCharacters.entrySet()) {
                word = word.replace(entry.getKey(), entry.getValue());
            }
        }
        return word;
    }

    public static void decode(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = ForbiddenCharacters.decode(args[i]);
        }
    }

    public static void main(String[] args) {
        int i;
        ForbiddenCharacters.init();
        String[] initalString = new String[]{"mariachi", "$return0", "[#POTATO]", "CLEAR;CLEAR", "SPACE INVADERS", "$KEY:@HASH#;$KEY", ">IOASSKl<d\u00f1lskf\u00f1ls 'das'", "comillas \" ", ";#$%&: ::***@,a", "--reserved"};
        String[] encodedString = new String[initalString.length];
        for (int i2 = 0; i2 < initalString.length; ++i2) {
            encodedString[i2] = ForbiddenCharacters.encode(initalString[i2], true);
        }
        String[] decoded1 = (String[])encodedString.clone();
        ForbiddenCharacters.decode(decoded1);
        String[] decoded2 = (String[])encodedString.clone();
        for (i = 0; i < decoded2.length; ++i) {
            decoded2[i] = ForbiddenCharacters.decode(decoded2[i]);
        }
        for (i = 0; i < initalString.length; ++i) {
            System.out.println("Inital String:         " + initalString[i]);
            System.out.println("Encode String:         " + encodedString[i]);
            System.out.println("Decode String Args:    " + decoded1[i]);
            System.out.println("Decode String:  Single " + decoded2[i]);
            String color = RED;
            boolean c1 = decoded1[i].equals(decoded2[i]);
            boolean c2 = initalString[i].equals(decoded1[i]);
            if (c1 && c2) {
                color = GREEN;
            }
            System.out.println(color + "TEST WORD: DIFFERNCE " + c1 + " result " + c2 + RESET + "\n");
        }
    }
}

