/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import net.jpountz.util.SafeUtils;
import net.jpountz.util.Utils;

public final class ByteBufferUtils
extends Enum<ByteBufferUtils> {
    private static final /* synthetic */ ByteBufferUtils[] $VALUES;

    public static ByteBufferUtils[] values() {
        return (ByteBufferUtils[])$VALUES.clone();
    }

    public static ByteBufferUtils valueOf(String name) {
        return Enum.valueOf(ByteBufferUtils.class, name);
    }

    public static void checkRange(ByteBuffer buf2, int off, int len) {
        SafeUtils.checkLength(len);
        if (len > 0) {
            ByteBufferUtils.checkRange(buf2, off);
            ByteBufferUtils.checkRange(buf2, off + len - 1);
        }
    }

    public static void checkRange(ByteBuffer buf2, int off) {
        if (off < 0 || off >= buf2.capacity()) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
    }

    public static ByteBuffer inLittleEndianOrder(ByteBuffer buf2) {
        if (buf2.order().equals(ByteOrder.LITTLE_ENDIAN)) {
            return buf2;
        }
        return buf2.duplicate().order(ByteOrder.LITTLE_ENDIAN);
    }

    public static ByteBuffer inNativeByteOrder(ByteBuffer buf2) {
        if (buf2.order().equals(Utils.NATIVE_BYTE_ORDER)) {
            return buf2;
        }
        return buf2.duplicate().order(Utils.NATIVE_BYTE_ORDER);
    }

    public static byte readByte(ByteBuffer buf2, int i) {
        return buf2.get(i);
    }

    public static void writeInt(ByteBuffer buf2, int i, int v) {
        assert (buf2.order() == Utils.NATIVE_BYTE_ORDER);
        buf2.putInt(i, v);
    }

    public static int readInt(ByteBuffer buf2, int i) {
        assert (buf2.order() == Utils.NATIVE_BYTE_ORDER);
        return buf2.getInt(i);
    }

    public static int readIntLE(ByteBuffer buf2, int i) {
        assert (buf2.order() == ByteOrder.LITTLE_ENDIAN);
        return buf2.getInt(i);
    }

    public static void writeLong(ByteBuffer buf2, int i, long v) {
        assert (buf2.order() == Utils.NATIVE_BYTE_ORDER);
        buf2.putLong(i, v);
    }

    public static long readLong(ByteBuffer buf2, int i) {
        assert (buf2.order() == Utils.NATIVE_BYTE_ORDER);
        return buf2.getLong(i);
    }

    public static long readLongLE(ByteBuffer buf2, int i) {
        assert (buf2.order() == ByteOrder.LITTLE_ENDIAN);
        return buf2.getLong(i);
    }

    public static void writeByte(ByteBuffer dest, int off, int i) {
        dest.put(off, (byte)i);
    }

    public static void writeShortLE(ByteBuffer dest, int off, int i) {
        dest.put(off, (byte)i);
        dest.put(off + 1, (byte)(i >>> 8));
    }

    public static void checkNotReadOnly(ByteBuffer buffer) {
        if (buffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
    }

    public static int readShortLE(ByteBuffer buf2, int i) {
        return buf2.get(i) & 0xFF | (buf2.get(i + 1) & 0xFF) << 8;
    }

    static {
        $VALUES = new ByteBufferUtils[0];
    }
}

