/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.ChannelDirectTCPIP;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Util;

public class ChannelDirectStreamLocal
extends ChannelDirectTCPIP {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    private static final byte[] _type = Util.str2byte("direct-streamlocal@openssh.com");
    private String socketPath;

    ChannelDirectStreamLocal() {
        this.type = _type;
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    @Override
    protected Packet genChannelOpenPacket() {
        if (this.socketPath == null) {
            this.session.getLogger().log(4, "socketPath must be set");
            throw new RuntimeException("socketPath must be set");
        }
        Buffer buf2 = new Buffer(50 + this.socketPath.length() + this.session.getBufferMargin());
        Packet packet = new Packet(buf2);
        packet.reset();
        buf2.putByte((byte)90);
        buf2.putString(this.type);
        buf2.putInt(this.id);
        buf2.putInt(this.lwsize);
        buf2.putInt(this.lmpsize);
        buf2.putString(Util.str2byte(this.socketPath));
        buf2.putString(Util.str2byte(this.originator_IP_address));
        buf2.putInt(this.originator_port);
        return packet;
    }

    public String getSocketPath() {
        return this.socketPath;
    }

    public void setSocketPath(String socketPath) {
        this.socketPath = socketPath;
    }
}

