/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.exceptions.CopyException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.gos.master.GOSAdaptor;
import es.bsc.compss.gos.master.GOSUri;
import es.bsc.compss.gos.master.GOSWorkerNode;
import es.bsc.compss.gos.master.exceptions.GOSCopyException;
import es.bsc.compss.gos.master.monitoring.GOSMonitoring;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import es.bsc.compss.gos.master.sshutils.staticmethods.SSHFileSystem;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.operation.OperationEndState;
import es.bsc.compss.types.data.operation.copy.ImmediateAsyncCopy;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GOSCopy
extends ImmediateAsyncCopy {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String ERR_NO_TGT_URI = "No valid target URIs";
    private static final String ERR_NO_SRC_URI = "No valid source URIs";
    private final String dbgPrefix;
    private boolean isBindingObject;
    private final GOSWorkerNode workerNode;
    private final String type;
    private GOSCopyState finishedState;

    public void logError(String s, Exception e) {
        LOGGER.error(this.dbgPrefix + s, (Throwable)e);
    }

    public void logError(String msg) {
        LOGGER.error(msg);
    }

    public void logWarn(String msg) {
        LOGGER.warn(this.dbgPrefix + msg);
    }

    public GOSWorkerNode getWorkerNode() {
        return this.workerNode;
    }

    public GOSCopy(LogicalData srcData, DataLocation srcLoc, DataLocation tgtLoc, LogicalData tgtData, Transferable reason, EventListener listener, GOSWorkerNode node, String type) {
        super(srcData, srcLoc, tgtLoc, tgtData, reason, listener);
        this.workerNode = node;
        this.type = type;
        this.isBindingObject();
        this.treatUris();
        this.finishedState = GOSCopyState.RUNNING;
        this.dbgPrefix = "[GOS_COPY " + this.getId() + "] ";
        LOGGER.debug(this.dbgPrefix + "created copy type " + type + " " + this);
    }

    public String toString() {
        String name = this.srcData != null ? this.srcData.getName() : "null";
        String path = this.srcLoc != null ? this.srcLoc.getPath() : "null";
        String s = "[" + name + " - " + path + "] ==> ";
        name = this.tgtData != null ? this.tgtData.getName() : "null";
        path = this.tgtLoc != null ? this.tgtLoc.getPath() : "null";
        s = s + "[" + name + " - " + path + "]";
        return s;
    }

    private void treatUris() {
        MultiURI uri;
        String path;
        Iterator<MultiURI> iterator = this.tgtLoc.getURIs().iterator();
        while (iterator.hasNext() && !(path = (uri = iterator.next()).getPath()).startsWith(File.separator)) {
            Resource host = uri.getHost();
            try {
                if (this.isBindingObject) {
                    this.tgtLoc = DataLocation.createLocation(host, host.getCompleteRemotePath(DataType.BINDING_OBJECT_T, path));
                    continue;
                }
                this.tgtLoc = DataLocation.createLocation(host, host.getCompleteRemotePath(DataType.FILE_T, path));
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
        }
    }

    private void isBindingObject() {
        this.isBindingObject = this.srcData.isBindingData() || this.reason != null && this.reason.getType().equals((Object)DataType.BINDING_OBJECT_T) || this.srcLoc != null && this.srcLoc.getType().equals((Object)LocationType.BINDING) || this.tgtData != null && this.tgtLoc.getType().equals((Object)LocationType.BINDING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void specificCopy() throws CopyException {
        List<GOSUri> selectedSourceURIs;
        LOGGER.debug(this.dbgPrefix + "performing specific copy");
        List<MultiURI> targetURIs = this.tgtLoc.getURIs();
        List<GOSUri> selectedTargetURIs = this.selectTargetUris(targetURIs);
        LogicalData logicalData = this.srcData;
        synchronized (logicalData) {
            selectedSourceURIs = this.selectSourceUris();
        }
        this.launchAsyncCopy(selectedSourceURIs, selectedTargetURIs);
    }

    private void launchAsyncCopy(List<GOSUri> listSrc, List<GOSUri> listDst) throws GOSCopyException {
        GOSTransferMonitor monitor;
        GOSUri src = listSrc.get(0);
        GOSUri dst = listDst.get(0);
        if (listSrc.size() > 1 || listDst.size() > 1) {
            LOGGER.debug("MORE THAN ONE SOURCE OR DST in doCopy");
        }
        try {
            monitor = SSHFileSystem.transferFile(this, src, dst);
        }
        catch (JSchException | SftpException | IOException e) {
            LOGGER.error(this.dbgPrefix + "Error in ssh transfer", (Throwable)e);
            throw new GOSCopyException(e);
        }
        if (monitor != null) {
            this.getMonitoring().addTransferMonitor(monitor);
        } else {
            LOGGER.warn("Monitor for " + this + " is null");
        }
    }

    private List<GOSUri> selectSourceUris() throws GOSCopyException {
        GOSUri internalURI;
        List<MultiURI> sourceURIs;
        LinkedList<GOSUri> selectedSourceURIs = new LinkedList<GOSUri>();
        if (this.srcLoc != null) {
            sourceURIs = this.srcLoc.getURIs();
            for (MultiURI uri : sourceURIs) {
                try {
                    internalURI = (GOSUri)uri.getInternalURI(GOSAdaptor.ID);
                    if (internalURI == null) continue;
                    selectedSourceURIs.add(internalURI);
                }
                catch (UnstartedNodeException une) {
                    LOGGER.error(this.dbgPrefix + "Exception selecting source URI");
                    throw new GOSCopyException(une);
                }
            }
        }
        LOGGER.debug(this.dbgPrefix + "SrcData: " + this.srcData);
        sourceURIs = this.srcData.getURIs();
        for (MultiURI uri : sourceURIs) {
            try {
                internalURI = (GOSUri)uri.getInternalURI(GOSAdaptor.ID);
                if (internalURI == null) continue;
                selectedSourceURIs.add(internalURI);
            }
            catch (UnstartedNodeException une) {
                LOGGER.error(this.dbgPrefix + "Exception selecting source URI for " + this.getName());
                throw new GOSCopyException(une);
            }
        }
        if (selectedSourceURIs.isEmpty()) {
            if (this.srcData.isInMemory()) {
                LOGGER.debug(this.dbgPrefix + "Data for " + this.getName() + " is in memory.");
                try {
                    this.srcData.writeToStorage();
                    sourceURIs = this.srcData.getURIs();
                    for (MultiURI uri : sourceURIs) {
                        internalURI = (GOSUri)uri.getInternalURI(GOSAdaptor.ID);
                        if (internalURI == null) continue;
                        selectedSourceURIs.add(internalURI);
                    }
                }
                catch (Exception e) {
                    LOGGER.error(this.dbgPrefix + "Exception writing object to file. " + e);
                    throw new GOSCopyException(ERR_NO_SRC_URI);
                }
            } else {
                LOGGER.error(this.dbgPrefix + ERR_NO_SRC_URI);
                throw new GOSCopyException(ERR_NO_SRC_URI);
            }
        }
        return selectedSourceURIs;
    }

    private List<GOSUri> selectTargetUris(List<MultiURI> targetURIs) throws GOSCopyException {
        LinkedList<GOSUri> selectedTargetURIs = new LinkedList<GOSUri>();
        for (MultiURI uri : targetURIs) {
            try {
                GOSUri internalURI = (GOSUri)uri.getInternalURI(GOSAdaptor.ID);
                if (internalURI == null) continue;
                selectedTargetURIs.add(internalURI);
            }
            catch (UnstartedNodeException une) {
                throw new GOSCopyException(une);
            }
        }
        if (selectedTargetURIs.isEmpty()) {
            LOGGER.error(this.dbgPrefix + ERR_NO_TGT_URI);
            throw new GOSCopyException(ERR_NO_TGT_URI);
        }
        return selectedTargetURIs;
    }

    public GOSMonitoring getMonitoring() {
        return this.workerNode.getConfig().getMonitoring();
    }

    public void markAsFinished(boolean success) {
        this.finishedState = success ? GOSCopyState.SUCCESSFUL : GOSCopyState.FAILED;
    }

    public void setState(GOSCopyState state) {
        this.finishedState = state;
    }

    public void notifyEnd() {
        if (this.finishedState.equals((Object)GOSCopyState.FAILED)) {
            LOGGER.debug(this.dbgPrefix + "copy was a failure.");
            GOSCopyException e = new GOSCopyException("Failure in Async GOSCopy..");
            this.notifyEndAsyncCopy(OperationEndState.OP_FAILED, e);
            return;
        }
        if (this.finishedState.equals((Object)GOSCopyState.SUCCESSFUL)) {
            LOGGER.debug(this.dbgPrefix + "copy " + this.type + " was a success.");
            this.notifyEndAsyncCopy(OperationEndState.OP_OK, null);
            return;
        }
        this.notifyEndAsyncCopy(OperationEndState.OP_IN_PROGRESS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEndAsyncCopy(OperationEndState state, CopyException e) {
        if (state.equals((Object)OperationEndState.OP_IN_PROGRESS)) {
            this.end(state);
            LOGGER.error("Should not be called in progress here.");
        }
        if (state.equals((Object)OperationEndState.OP_OK)) {
            LogicalData logicalData = this.srcData;
            synchronized (logicalData) {
                DataLocation actualLocation = this.srcData.finishedCopy(this);
                if (this.tgtData != null && actualLocation != null) {
                    LogicalData logicalData2 = this.tgtData;
                    synchronized (logicalData2) {
                        this.tgtData.addLocation(actualLocation);
                    }
                }
            }
            this.end(state);
            LOGGER.debug(this.dbgPrefix + "Async copy done " + this.getName() + " done.");
        } else {
            LOGGER.debug(this.dbgPrefix + "Failure during copy.");
            this.end(state, e);
        }
    }

    public static enum GOSCopyState {
        RUNNING,
        FAILED,
        SUCCESSFUL;

    }
}

