/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.sshutils.staticmethods;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import es.bsc.compss.gos.master.GOSCopy;
import es.bsc.compss.gos.master.GOSUri;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSDifferentHostsTransfer;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSOneWayTransferMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSSameHostCopyMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.GOSTransferMonitor;
import es.bsc.compss.gos.master.monitoring.transfermonitor.sftpmonitor.GOSJschTransferMonitor;
import es.bsc.compss.gos.master.sshutils.SSHChannel;
import es.bsc.compss.gos.master.sshutils.SSHGlobalHostCollection;
import es.bsc.compss.gos.master.sshutils.SSHHost;
import es.bsc.compss.util.ErrorManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHFileSystem {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String DBG_PREFIX = "[SSHFileSystem] ";

    public static GOSTransferMonitor transferFile(GOSCopy copy, GOSUri src, GOSUri dst) throws IOException, JSchException, SftpException {
        if (src.isLocal() && dst.isLocal()) {
            new File(dst.getPath()).getParentFile().mkdirs();
            LOGGER.info("[SSHFileSystem] Sending data with sftp from local: " + src.getPath() + " to local: " + dst.getPath());
            if (!new File(src.getPath()).exists()) {
                ErrorManager.error("Could not find local file: " + src.getPath() + ".");
                throw new IOException("[SSHFileSystem] No file in src path");
            }
            Files.copy(Paths.get(src.getPath(), new String[0]), Paths.get(dst.getPath(), new String[0]), new CopyOption[0]);
            copy.markAsFinished(true);
            copy.notifyEnd();
            return null;
        }
        if (src.isLocal()) {
            LOGGER.info("[SSHFileSystem] Sending data with sftp from local: " + src.getPath() + " to remote: " + dst);
            if (new File(src.getPath()).exists()) {
                return SSHFileSystem.sendFile(copy, src, dst);
            }
            ErrorManager.error("Could not find local file: " + src.getPath() + ".");
            throw new IOException("[SSHFileSystem] No file in src path");
        }
        if (dst.isLocal()) {
            LOGGER.info("[SSHFileSystem] Receiving data with sftp from remote: " + src + " to local: " + dst.getPath());
            return SSHFileSystem.getFile(copy, src, dst);
        }
        LOGGER.info("Sending data with sftp from remote: " + src + " to remote: " + dst);
        return SSHFileSystem.getAndSendFile(copy, src, dst);
    }

    private static GOSTransferMonitor getAndSendFile(GOSCopy copy, GOSUri src, GOSUri dst) throws JSchException, SftpException, IOException {
        SSHGlobalHostCollection ghc = SSHFileSystem.getAllHosts(copy);
        SSHHost dstHost = ghc.getHost(dst.getUser(), dst.getHost());
        SSHHost srcHost = ghc.getHost(src.getUser(), src.getHost());
        if (dstHost.hashCode() == srcHost.hashCode()) {
            return SSHFileSystem.getAndSendFileSameHost(copy, src, dst);
        }
        return SSHFileSystem.getAndSendFileDifferentHost(copy, src, dst);
    }

    private static SSHGlobalHostCollection getAllHosts(GOSCopy copy) {
        return copy.getWorkerNode().getAdaptorClass().getHosts();
    }

    private static GOSTransferMonitor getAndSendFileSameHost(GOSCopy copy, GOSUri src, GOSUri dst) throws JSchException, SftpException {
        SSHGlobalHostCollection ghc = SSHFileSystem.getAllHosts(copy);
        SSHHost srcHost = ghc.getHost(src.getUser(), src.getHost());
        SSHChannel exec = srcHost.openChannel("exec", "execSameHost");
        exec.setCommand("cp " + src.getPath() + " " + dst.getPath());
        exec.connect();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(exec.getErrStream()));
        }
        catch (IOException e) {
            ErrorManager.error("Error in executing command", e);
        }
        SSHChannel sftp = srcHost.openChannel("sftp", "sftpSameHost");
        sftp.connect();
        sftp.cd("/");
        long size = sftp.lstat(dst.getPath()).getSize();
        GOSSameHostCopyMonitor monitor = new GOSSameHostCopyMonitor(copy, exec, sftp, reader, dst.getPath(), size);
        exec.connect();
        return monitor;
    }

    private static GOSTransferMonitor getAndSendFileDifferentHost(GOSCopy copy, GOSUri src, GOSUri dst) throws JSchException, SftpException, IOException {
        SSHGlobalHostCollection ghc = SSHFileSystem.getAllHosts(copy);
        SSHHost dstHost = ghc.getHost(dst.getUser(), dst.getHost());
        SSHHost srcHost = ghc.getHost(src.getUser(), src.getHost());
        String srcPath = src.getPath();
        String dstPath = dst.getPath();
        SSHChannel getChannel = srcHost.openChannel("sftp", "DifferentHost-src");
        getChannel.connect();
        getChannel.cd("/");
        SSHChannel sendChannel = dstHost.openChannel("sftp", "DifferentHost-dst");
        sendChannel.connect();
        sendChannel.cd("/");
        GOSJschTransferMonitor monitor = new GOSJschTransferMonitor();
        Path p = Files.createTempFile("copy" + copy.getId() + "-transfer", "file", new FileAttribute[0]);
        File tmp = p.toFile();
        GOSDifferentHostsTransfer transfer = new GOSDifferentHostsTransfer(copy, getChannel, sendChannel, srcPath, dstPath, tmp, monitor);
        getChannel.get(srcPath, tmp.getPath(), monitor);
        return transfer;
    }

    private static GOSTransferMonitor sendFile(GOSCopy copy, GOSUri src, GOSUri dst) throws JSchException, SftpException {
        SSHGlobalHostCollection ghc = SSHFileSystem.getAllHosts(copy);
        SSHHost dstHost = ghc.getHost(dst.getUser(), dst.getHost());
        SSHChannel channelSftp = dstHost.openChannel("sftp", "sendFtp");
        channelSftp.connect();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[SSHFileSystem] pwd: " + channelSftp.pwd());
        }
        channelSftp.cd("/");
        GOSJschTransferMonitor m = new GOSJschTransferMonitor();
        channelSftp.put(src.getPath(), dst.getPath(), m);
        GOSOneWayTransferMonitor monitor = new GOSOneWayTransferMonitor(copy, m, channelSftp);
        return monitor;
    }

    private static GOSTransferMonitor getFile(GOSCopy copy, GOSUri src, GOSUri dst) throws JSchException, SftpException {
        SSHGlobalHostCollection ghc = SSHFileSystem.getAllHosts(copy);
        SSHHost srcHost = ghc.getHost(src.getUser(), src.getHost());
        String srcPath = src.getPath();
        String dstPath = dst.getPath();
        new File(dst.getPath()).getParentFile().mkdirs();
        SSHChannel channelSftp = srcHost.openChannel("sftp", "getSftp");
        channelSftp.connect();
        new File(dst.getPath()).getParentFile().mkdirs();
        GOSJschTransferMonitor m = new GOSJschTransferMonitor();
        channelSftp.get(srcPath, dstPath, m);
        GOSOneWayTransferMonitor monitor = new GOSOneWayTransferMonitor(copy, m, channelSftp);
        return monitor;
    }

    private static void createDirectoriesRemote(ChannelSftp channelSftp, String path) throws SftpException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[SSHFileSystem] Creating Directories in remote machine");
        }
        String[] splitPath = path.split("/");
        String homePath = channelSftp.pwd();
        for (int i = 0; i < splitPath.length - 1; ++i) {
            if (splitPath[i].isEmpty()) continue;
            try {
                channelSftp.ls(splitPath[i]);
            }
            catch (SftpException e) {
                channelSftp.mkdir(splitPath[i]);
            }
            channelSftp.cd(splitPath[i]);
        }
        channelSftp.cd(homePath);
    }

    public static void appendFile(SSHHost host, String src, String dst) throws JSchException, SftpException {
        SSHChannel channelSftp = host.openChannel("sftp", "append");
        channelSftp.connect();
        GOSJschTransferMonitor monitor = new GOSJschTransferMonitor();
        channelSftp.get(src, dst, monitor, 2);
        while (!monitor.finished) {
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        channelSftp.disconnect();
    }
}

