/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.gos.master.monitoring.jobmonitor;

import es.bsc.compss.gos.master.GOSJob;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSHostsManager;
import es.bsc.compss.gos.master.monitoring.jobmonitor.GOSSingleJobManager;
import java.util.concurrent.ConcurrentHashMap;

public class GOSHostsInteractiveManager
implements GOSHostsManager {
    protected final ConcurrentHashMap<String, GOSSingleJobManager> activeJobs = new ConcurrentHashMap();

    public GOSHostsInteractiveManager(GOSJob job) {
        this.addJobMonitor(job);
    }

    @Override
    public synchronized void addJobMonitor(GOSJob job) {
        this.activeJobs.put(job.getCompositeID(), new GOSSingleJobManager(job));
    }

    @Override
    public boolean existsRunningJobs() {
        return !this.activeJobs.isEmpty();
    }

    @Override
    public void monitor() {
        for (Object o : this.activeJobs.values().toArray()) {
            GOSSingleJobManager sjm = (GOSSingleJobManager)o;
            if (!sjm.monitor()) continue;
            this.removeJobMonitor(sjm.getID());
        }
    }

    private synchronized void removeJobMonitor(String id) {
        this.activeJobs.remove(id);
    }

    @Override
    public int countActiveJobs() {
        return this.activeJobs.size();
    }

    @Override
    public void shutdown() {
        for (GOSSingleJobManager jm : this.activeJobs.values()) {
            jm.shutdown();
        }
        this.activeJobs.clear();
    }
}

