/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.http.master;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.http.master.HTTPController;
import es.bsc.compss.http.master.HTTPInstance;
import es.bsc.compss.http.master.HTTPJob;
import es.bsc.compss.http.master.Response;
import es.bsc.compss.http.master.URLReplacer;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.implementations.HTTPImplementation;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class HTTPCaller
extends RequestDispatcher<HTTPJob> {
    private static final String SUBMIT_ERROR = "Error calling HTTP Service";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String URL_PARAMETER_OPEN_TOKEN = "\\{\\{";
    private static final String URL_PARAMETER_CLOSE_TOKEN = "\\}\\}";

    public HTTPCaller(RequestQueue<HTTPJob> queue) {
        super(queue);
    }

    public void processRequests() {
        HTTPJob job;
        while ((job = (HTTPJob)((Object)this.queue.dequeue())) != null) {
            try {
                TaskDescription taskDescription = job.getTaskParams();
                Map<String, String> namedParameters = this.constructMapOfNamedParameters(taskDescription);
                HTTPImplementation httpImplementation = (HTTPImplementation)job.getImplementation();
                LOGGER.debug("Executing HTTP Request...");
                HTTPInstance httpInstance = (HTTPInstance)job.getResourceNode();
                Response httpResponse = this.performHttpRequest(httpInstance.getConfig().getBaseUrl(), namedParameters, httpImplementation);
                String updates = httpImplementation.getUpdates();
                this.formatResponse(httpResponse, httpImplementation.getProduces());
                this.updateResponse(httpResponse, updates, namedParameters);
                this.processResponse(job, httpResponse);
            }
            catch (Exception e) {
                job.failed(JobEndStatus.EXECUTION_FAILED);
                LOGGER.error(SUBMIT_ERROR, (Throwable)e);
            }
        }
    }

    private void extractPaths(JsonObject produces, Map<Object, String> map, String previousPath) {
        Iterator<String> iterator = produces.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String keyStr = key = iterator.next();
            JsonElement value = produces.get(keyStr);
            String path = "";
            if (value instanceof JsonObject) {
                path = previousPath + "," + keyStr;
                this.extractPaths((JsonObject)value, map, path);
                continue;
            }
            String retKey = produces.getAsJsonPrimitive(keyStr).getAsString();
            map.put(this.formatKey(retKey), previousPath + "," + keyStr);
        }
    }

    private String formatKey(String key) {
        return key.replaceAll(URL_PARAMETER_OPEN_TOKEN, "\\$").replaceAll(URL_PARAMETER_CLOSE_TOKEN, "");
    }

    private void updateResponse(Response response, String updates, Map<String, String> namedParameters) {
        if (updates == null || updates.equals("[unassigned]") || updates.equals("null") || updates.equals("#")) {
            return;
        }
        String tbu = updates.split("=")[0];
        String tbuName = tbu.split("\\.")[0].trim();
        tbuName = tbuName.replaceAll(URL_PARAMETER_OPEN_TOKEN, "").replaceAll(URL_PARAMETER_CLOSE_TOKEN, "");
        String tbuKey = tbu.split("\\.")[1].trim();
        JsonElement outParamEl = JsonParser.parseString(namedParameters.get(tbuName));
        JsonObject outParam = outParamEl.getAsJsonObject();
        if (outParam.has(tbuKey)) {
            outParam.remove(tbuKey);
        }
        String subsParName = updates.split("=")[1].trim();
        JsonObject resBody = (JsonObject)response.getResponseBody();
        JsonElement newValue = resBody.get(this.formatKey(subsParName));
        outParam.add(tbuKey, newValue);
        resBody.remove(tbuName);
        resBody.add(tbuName, outParam);
        response.setResponseBody(resBody);
    }

    private void formatResponse(Response response, String produces) {
        if (produces == null || produces.equals("[unassigned]") || produces.equals("null") || produces.equals("#")) {
            JsonElement respBodyElem = JsonParser.parseString(response.getResponseBody().toString());
            JsonObject newBody = new JsonObject();
            newBody.add("$return_0", respBodyElem);
            response.setResponseBody(newBody);
            return;
        }
        JsonElement element = JsonParser.parseString(produces);
        JsonObject producesJSONObj = element.getAsJsonObject();
        HashMap<Object, String> paths = new HashMap<Object, String>();
        this.extractPaths(producesJSONObj, paths, "");
        JsonElement bodyJsonElement = JsonParser.parseString(response.getResponseBody().toString());
        JsonObject bodyJsonObject = bodyJsonElement.getAsJsonObject();
        JsonObject newBody = new JsonObject();
        for (Object key : paths.keySet()) {
            String keyString = ((String)paths.get(key)).replaceFirst(",", "");
            newBody.add((String)key, this.extractValueFromJsonResponse(bodyJsonObject, keyString));
        }
        response.setResponseBody(newBody);
    }

    private JsonElement extractValueFromJsonResponse(JsonObject json, String keyString) {
        String[] keys = keyString.split(",");
        for (int i = 0; i < keys.length - 1; ++i) {
            json = json.getAsJsonObject(keys[0]);
        }
        return json.get(keys[keys.length - 1]);
    }

    private String[] extractKeys(String produces) {
        String[] keys = produces.replaceAll("#", "").split(",");
        for (int i = 0; i < keys.length; ++i) {
            String tmp = keys[i].trim();
            tmp = tmp.replaceAll(URL_PARAMETER_OPEN_TOKEN, "");
            keys[i] = tmp = tmp.replaceAll(URL_PARAMETER_CLOSE_TOKEN, "");
        }
        return keys;
    }

    private void processResponse(HTTPJob job, Response response) {
        int httpResponseCode = response.getResponseCode();
        if (httpResponseCode >= 200 && httpResponseCode < 300) {
            LOGGER.debug("Correct HTTP response with response code " + httpResponseCode);
            job.setReturnValue(response.getResponseBody());
            job.completed();
        } else {
            LOGGER.debug("Job failing due to wrong HTTP response with response code " + httpResponseCode);
            job.failed(JobEndStatus.EXECUTION_FAILED);
        }
    }

    private Response performHttpRequest(String baseUrl, Map<String, String> namedParameters, HTTPImplementation httpImplementation) throws IOException {
        String fullUrl = baseUrl + httpImplementation.getResource();
        String requestType = httpImplementation.getRequest();
        String parsedUrl = URLReplacer.replaceUrlParameters(fullUrl, namedParameters, URL_PARAMETER_OPEN_TOKEN, URL_PARAMETER_CLOSE_TOKEN);
        String payload = httpImplementation.getPayload();
        String payloadType = httpImplementation.getPayloadType();
        payload = URLReplacer.formatPayload(payload, namedParameters, URL_PARAMETER_OPEN_TOKEN, URL_PARAMETER_CLOSE_TOKEN);
        return HTTPController.performRequestAndGetResponse(requestType, parsedUrl, payload, payloadType);
    }

    private Map<String, String> constructMapOfNamedParameters(TaskDescription taskDescription) throws CannotLoadException {
        HashMap<String, String> namedParameters = new HashMap<String, String>();
        for (Parameter par : taskDescription.getParameters()) {
            Direction parameterDirection = par.getDirection();
            if (parameterDirection == Direction.IN || parameterDirection == Direction.INOUT || parameterDirection == Direction.IN_DELETE) {
                switch (par.getType()) {
                    case FILE_T: {
                        String content;
                        DependencyParameter fileParam = (DependencyParameter)par;
                        if (par.getContentType() != null && (par.getContentType().toUpperCase().equals("FILE") || par.getContentType().toUpperCase().equals("FILE_T"))) {
                            content = HTTPCaller.readFile(fileParam.getDataTarget());
                            namedParameters.put(par.getName(), content);
                            break;
                        }
                        content = this.extractJsonString(fileParam.getDataTarget());
                        if (content != null) {
                            namedParameters.put(par.getName(), content);
                            break;
                        }
                        LOGGER.warn("UNSUPPORTED JSON PARAMETER IN HTTP TASK: " + fileParam.getName());
                        break;
                    }
                    case OBJECT_T: 
                    case PSCO_T: 
                    case EXTERNAL_PSCO_T: {
                        DependencyParameter dependencyParameter = (DependencyParameter)par;
                        Object objectValue = this.getObjectValue(dependencyParameter);
                        this.addParameterToMapOfParameters(namedParameters, par, objectValue);
                        break;
                    }
                    case STREAM_T: 
                    case EXTERNAL_STREAM_T: {
                        LOGGER.error("Error: HTTP CAN'T USE STREAMS AS PARAMETERS!");
                        break;
                    }
                    case BINDING_OBJECT_T: {
                        LOGGER.error("Error: HTTP CAN'T USE BINDING OBJECTS AS PARAMETERS!");
                        break;
                    }
                    case DICT_COLLECTION_T: {
                        LOGGER.error("Error: HTTP CAN'T USE DICTIONARY COLLECTION OBJECTS AS PARAMETERS!");
                        break;
                    }
                    default: {
                        BasicTypeParameter basicTypeParameter = (BasicTypeParameter)par;
                        this.addParameterToMapOfParameters(namedParameters, par, basicTypeParameter.getValue());
                    }
                }
                continue;
            }
            if (parameterDirection != Direction.OUT) continue;
            LOGGER.debug("Out parameter of HTTPCaller: " + par);
        }
        return namedParameters;
    }

    private String extractJsonString(String fileName) {
        String jsonContent = HTTPCaller.readFile(fileName).substring(4);
        JsonElement jsonElement = JsonParser.parseString(jsonContent);
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsJsonPrimitive().toString();
        }
        if (jsonElement.isJsonObject()) {
            return jsonElement.toString();
        }
        if (jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray().toString();
        }
        return null;
    }

    private void addParameterToMapOfParameters(Map<String, String> namedParameters, Parameter par, Object o) {
        String key = par.getName();
        if (key != null && !key.isEmpty()) {
            String s = this.convertObjectToString(o);
            String value = String.valueOf(s);
            namedParameters.put(key, value);
        }
    }

    private String convertObjectToString(Object o) {
        if (o instanceof Integer) {
            return Integer.toString((Integer)o);
        }
        if (o instanceof Float) {
            return String.valueOf(o);
        }
        return (String)o;
    }

    private Object getObjectValue(DependencyParameter dp) throws CannotLoadException {
        DataAccessId dataAccessId = dp.getDataAccessId();
        DataInstanceId dataInstanceId = dp.getDirection() == Direction.IN ? ((RAccessId)dataAccessId).getReadDataInstance() : ((RWAccessId)dataAccessId).getReadDataInstance();
        String renaming = dataInstanceId.getRenaming();
        LogicalData logicalData = Comm.getData((String)renaming);
        if (!logicalData.isInMemory()) {
            logicalData.loadFromStorage();
        }
        return logicalData.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String fileName) {
        File f = new File(fileName);
        BufferedReader br = null;
        String contents = "";
        try {
            String line;
            br = new BufferedReader(new FileReader(f));
            while ((line = br.readLine()) != null) {
                contents = contents + line;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contents;
    }
}

