/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.http.master;

import es.bsc.compss.http.master.HTTPCaller;
import es.bsc.compss.http.master.HTTPInstance;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPJob
extends Job<HTTPInstance> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String SUBMIT_ERROR = "Error calling HTP Service";
    private static final int POOL_SIZE = 10;
    private static final String POOL_NAME = "HTTP";
    private static RequestQueue<HTTPJob> callerQueue;
    private static HTTPCaller caller;
    private static ThreadPool callerPool;
    private Object returnValue = null;

    public static void init() {
        if (callerQueue == null) {
            callerQueue = new RequestQueue();
        } else {
            callerQueue.clear();
        }
        caller = new HTTPCaller(callerQueue);
        callerPool = new ThreadPool(10, POOL_NAME, (RequestDispatcher)caller);
        callerPool.startThreads();
    }

    public static void end() {
        callerPool.stopThreads();
    }

    public HTTPJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, taskParams, impl, res, listener, predecessors, numSuccessors);
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public TaskType getType() {
        return TaskType.HTTP;
    }

    public void submit() {
        callerQueue.enqueue((Object)this);
    }

    public void cancelJob() {
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.taskParams.toString());
        String name = "";
        COMPSsWorker node = this.getResourceNode();
        name = node.getName();
        buffer.append(", [Target URL: ").append(name).append("]]");
        return buffer.toString();
    }

    public String getHostName() {
        return ((HTTPInstance)this.getResourceNode()).getName();
    }
}

