/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.http.master;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.http.master.HTTPCaller;
import es.bsc.compss.http.master.HTTPInstance;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.job.JobImpl;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.RequestDispatcher;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.ThreadPool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPJob
extends JobImpl<HTTPInstance> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final String ERR_SERIALIZE_TO_FILE = "Cannot serialize to file HTTP Result";
    private static final int POOL_SIZE = Integer.parseInt(System.getenv().getOrDefault("COMPSS_HTTP_POOL_SIZE", "100"));
    private static final String POOL_NAME = "HTTP";
    private static RequestQueue<HTTPJob> callerQueue;
    private static Gson gson;
    private static HTTPCaller caller;
    private static ThreadPool callerPool;

    public static void init() {
        if (callerQueue == null) {
            callerQueue = new RequestQueue();
        } else {
            callerQueue.clear();
        }
        caller = new HTTPCaller(callerQueue);
        callerPool = new ThreadPool(POOL_SIZE, POOL_NAME, (RequestDispatcher)caller);
        callerPool.startThreads();
    }

    public static void end() {
        callerPool.stopThreads();
    }

    public HTTPJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        super(taskId, taskParams, impl, res, listener, predecessors, numSuccessors);
    }

    public TaskType getType() {
        return TaskType.HTTP;
    }

    public void submitJob() {
        callerQueue.enqueue((Object)this);
    }

    public void cancelJob() {
    }

    public void completed(JsonObject retValue) {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        List params = this.taskParams.getParameters();
        int subParamIdx = 0;
        for (Parameter p : params) {
            if (p.isPotentialDependency()) {
                DependencyParameter dp = (DependencyParameter)p;
                String dataName = this.getOuputRename(p);
                if (dataName != null) {
                    this.registerParameterResult(dp, dataName, retValue);
                    this.notifyResultAvailability(new int[]{subParamIdx}, dp, dataName);
                }
            }
            ++subParamIdx;
        }
        super.completed();
    }

    public void failed(JobEndStatus status) {
        if (this.history == JobHistory.CANCELLED) {
            LOGGER.error("Ignoring notification since the job was cancelled");
            this.removeTmpData();
            return;
        }
        switch (this.taskParams.getOnFailure()) {
            case IGNORE: 
            case CANCEL_SUCCESSORS: {
                List params = this.taskParams.getParameters();
                int subParamIdx = 0;
                for (Parameter p : params) {
                    if (p.isPotentialDependency()) {
                        DependencyParameter dp = (DependencyParameter)p;
                        String dataName = this.getOuputRename(p);
                        if (dataName != null) {
                            this.emptyParameterResult(dp, dataName);
                            this.notifyResultAvailability(new int[]{subParamIdx}, dp, dataName);
                        }
                    }
                    ++subParamIdx;
                }
                break;
            }
            default: {
                this.removeTmpData();
            }
        }
        super.failed(status);
    }

    protected void registerAllJobOutputsAsExpected() {
    }

    private void emptyParameterResult(DependencyParameter dp, String dataName) {
        if (dp.getType() == DataType.FILE_T) {
            try {
                File f = new File(dp.getDataTarget());
                f.createNewFile();
            }
            catch (IOException e) {
                ErrorManager.error((String)ERR_SERIALIZE_TO_FILE, (Exception)e);
            }
            SimpleURI uri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + dp.getDataTarget());
            try {
                DataLocation outLoc = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)uri);
                Comm.registerLocation((String)dataName, (DataLocation)outLoc);
            }
            catch (IOException e) {
                ErrorManager.error((String)("ERROR: Invalid location URI " + dp.getDataTarget()), (Exception)e);
            }
        } else {
            Object value = null;
            LogicalData ld = Comm.registerValue((String)dataName, value);
            for (DataLocation dl : ld.getLocations()) {
                dp.setDataTarget(dl.getPath());
            }
        }
    }

    private void registerParameterResult(DependencyParameter dp, String dataName, JsonObject retValue) {
        if (dp.getType() == DataType.FILE_T) {
            try {
                this.storeFileResult(retValue.get(dp.getName()), dp.getDataTarget());
            }
            catch (IOException e) {
                ErrorManager.error((String)ERR_SERIALIZE_TO_FILE, (Exception)e);
            }
            SimpleURI uri = new SimpleURI(ProtocolType.FILE_URI.getSchema() + dp.getDataTarget());
            try {
                DataLocation outLoc = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)uri);
                Comm.registerLocation((String)dataName, (DataLocation)outLoc);
            }
            catch (IOException e) {
                ErrorManager.error((String)("ERROR: Invalid location URI " + dp.getDataTarget()), (Exception)e);
            }
        } else {
            Object value;
            if (dp.getType() == DataType.OBJECT_T) {
                JsonPrimitive objectValue = retValue.getAsJsonPrimitive("$return_0");
                value = this.getObjectResult(objectValue, dp.getContentType());
            } else {
                JsonPrimitive primValue = retValue.getAsJsonPrimitive("$return_0");
                value = this.getPrimitiveResult(primValue, dp.getType());
            }
            LogicalData ld = Comm.registerValue((String)dataName, (Object)value);
            for (DataLocation dl : ld.getLocations()) {
                dp.setDataTarget(dl.getPath());
            }
        }
    }

    private Object getObjectResult(JsonPrimitive primValue, String contentType) {
        Object value;
        switch (contentType) {
            case "int": {
                value = gson.fromJson((JsonElement)primValue, Integer.TYPE);
                break;
            }
            case "long": {
                value = gson.fromJson((JsonElement)primValue, Long.TYPE);
                break;
            }
            case "java.lang.String": {
                value = gson.fromJson((JsonElement)primValue, String.class);
                break;
            }
            default: {
                value = gson.fromJson((JsonElement)primValue, Object.class);
            }
        }
        return value;
    }

    private Object getPrimitiveResult(JsonPrimitive primValue, DataType type) {
        Object value;
        switch (type) {
            case INT_T: {
                value = gson.fromJson((JsonElement)primValue, Integer.TYPE);
                break;
            }
            case LONG_T: {
                value = gson.fromJson((JsonElement)primValue, Long.TYPE);
                break;
            }
            case STRING_T: {
                value = gson.fromJson((JsonElement)primValue, String.class);
                break;
            }
            case STRING_64_T: {
                String temp = gson.fromJson((JsonElement)primValue, String.class);
                byte[] encoded = Base64.getEncoder().encode(temp.getBytes());
                value = new String(encoded);
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private void storeFileResult(JsonElement value, String location) throws IOException {
        FileWriter file = new FileWriter(location);
        file.write("0004");
        file.write(value.toString());
        file.close();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Job id: ").append(this.getJobId()).append("]");
        buffer.append(", ").append(this.taskParams.toString());
        String name = "";
        COMPSsWorker node = this.getResourceNode();
        name = node.getName();
        buffer.append(", [Target URL: ").append(name).append("]]");
        return buffer.toString();
    }

    static {
        gson = new Gson();
    }
}

