/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.http.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.http.master.HTTPAdaptor;
import es.bsc.compss.http.master.HTTPJob;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.resources.configuration.HTTPConfiguration;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import java.util.List;

public class HTTPInstance
extends COMPSsWorker {
    private final String httpWorkerName;
    private final HTTPConfiguration config;

    public HTTPInstance(HTTPConfiguration config, NodeMonitor monitor, String httpWorkerName) {
        super(monitor);
        this.config = config;
        this.httpWorkerName = httpWorkerName;
    }

    public String getName() {
        return this.httpWorkerName;
    }

    public String getAdaptor() {
        return HTTPAdaptor.class.getCanonicalName();
    }

    public Object getProjectProperties() {
        return null;
    }

    public Object getResourcesProperties() {
        return null;
    }

    public void start() throws InitNodeException {
    }

    public void setInternalURI(MultiURI uri) {
    }

    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return new HTTPJob(taskId, taskParams, impl, res, listener, predecessors, numSuccessors);
    }

    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
    }

    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        String path = target.getProtocol().getSchema() + target.getPath();
        DataLocation tgtLoc = null;
        try {
            SimpleURI uri = new SimpleURI(path);
            tgtLoc = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)uri);
        }
        catch (Exception e) {
            ErrorManager.error((String)("ERROR: Invalid location URI " + path), (Exception)e);
        }
        COMPSsNode node = Comm.getAppHost().getNode();
        node.obtainData(ld, source, tgtLoc, tgtData, reason, listener);
    }

    public void enforceDataObtaining(Transferable reason, EventListener listener) {
        listener.notifyEnd(null);
    }

    public void updateTaskCount(int processorCoreCount) {
    }

    public void announceDestruction() {
    }

    public void announceCreation() {
    }

    public String getUser() {
        return "";
    }

    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case COLLECTION_T: 
            case FILE_T: {
                path = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + name;
                break;
            }
            case OBJECT_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + name;
                break;
            }
            case STREAM_T: {
                path = ProtocolType.STREAM_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_STREAM_T: {
                path = ProtocolType.EXTERNAL_STREAM_URI.getSchema() + Comm.getAppHost().getWorkingDirectory() + name;
                break;
            }
            case PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    public DataLocation getTargetLocation(Resource resource, DataType type, String name) {
        SimpleURI workingPath = this.getCompletePath(type, name);
        DataLocation target = null;
        try {
            target = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)workingPath);
        }
        catch (Exception e) {
            ErrorManager.error((String)("ERROR: Invalid location URI " + workingPath.toString()), (Exception)e);
        }
        return target;
    }

    public void deleteTemporary() {
    }

    public boolean generatePackage() {
        return false;
    }

    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        sl.notifyEnd();
    }

    public boolean generateWorkersDebugInfo() {
        return false;
    }

    public String getClasspath() {
        return "";
    }

    public String getPythonpath() {
        return "";
    }

    public void increaseComputingCapabilities(ResourceDescription description) {
    }

    public void reduceComputingCapabilities(ResourceDescription description) {
    }

    public void removeObsoletes(List<MultiURI> obsoletes) {
    }

    public void verifyNodeIsRunning() {
    }

    public HTTPConfiguration getConfig() {
        return this.config;
    }
}

