/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.http.master;

import com.google.gson.Gson;
import es.bsc.compss.http.master.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class HTTPController {
    public static Response performRequestAndGetResponse(String request, String fullUrl, String payload, String payloadType) throws IOException {
        String jsonBody;
        URL url = new URL(fullUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(request);
        if (request.equals("POST")) {
            HTTPController.performPostRequest(connection, payload, payloadType);
        }
        int responseCode = connection.getResponseCode();
        String responseBody = HTTPController.getResponseBody(connection);
        boolean isJson = false;
        Map<String, List<String>> headers = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            if (entry.getKey() == null || !entry.getKey().equals("Content-Type") || entry.getValue() == null || entry.getValue().get(0) == null || !entry.getValue().get(0).equals("application/json")) continue;
            isJson = true;
            break;
        }
        if (!isJson) {
            Gson gson = new Gson();
            jsonBody = gson.toJson(responseBody);
        } else {
            jsonBody = responseBody;
        }
        return new Response(responseCode, jsonBody);
    }

    private static void performPostRequest(HttpURLConnection connection, String payload, String payloadType) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Type", payloadType);
        byte[] out = payload.getBytes();
        OutputStream stream = connection.getOutputStream();
        stream.write(out);
    }

    private static String getResponseBody(HttpURLConnection connection) throws IOException {
        String line;
        InputStream inputStream = connection.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuffer = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            stringBuffer.append(line);
        }
        bufferedReader.close();
        connection.disconnect();
        return stringBuffer.toString();
    }
}

