/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.binders;

import es.bsc.compss.types.execution.ThreadBinder;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableComputingUnitsException;

public class BindToResource
implements ThreadBinder {
    private final int[] bindedComputingUnits;

    public BindToResource(int numThreads) {
        this.bindedComputingUnits = new int[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.bindedComputingUnits[i] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int[] bindComputingUnits(int jobId, int numCUs) throws UnsufficientAvailableComputingUnitsException {
        int[] assignedCoreUnits = new int[numCUs];
        int numAssignedCores = 0;
        if (numCUs <= 0) return assignedCoreUnits;
        int[] nArray = this.bindedComputingUnits;
        synchronized (this.bindedComputingUnits) {
            for (int coreId = 0; coreId < this.bindedComputingUnits.length; ++coreId) {
                if (this.bindedComputingUnits[coreId] == -1) {
                    this.bindedComputingUnits[coreId] = jobId;
                    assignedCoreUnits[numAssignedCores] = coreId;
                    ++numAssignedCores;
                }
                if (numAssignedCores == numCUs) break;
            }
            if (numAssignedCores == numCUs) return assignedCoreUnits;
            this.releaseComputingUnits(jobId);
            throw new UnsufficientAvailableComputingUnitsException("Not enough available computing units for task execution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseComputingUnits(int jobId) {
        int[] nArray = this.bindedComputingUnits;
        synchronized (this.bindedComputingUnits) {
            for (int coreId = 0; coreId < this.bindedComputingUnits.length; ++coreId) {
                if (this.bindedComputingUnits[coreId] != jobId) continue;
                this.bindedComputingUnits[coreId] = -1;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

