/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.local;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Stream;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamURI;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.List;

public class LocalParameter
implements InvocationParam {
    private final Parameter param;
    private final boolean preserveSourceData;
    private final boolean writeFinalValue;
    private final String dataMgmtId;
    private String originalName;
    private Object value;
    private Class<?> valueClass;

    public LocalParameter(Parameter param) {
        this.param = param;
        DataType type = param.getType();
        switch (type) {
            case FILE_T: 
            case OBJECT_T: 
            case PSCO_T: 
            case EXTERNAL_PSCO_T: 
            case BINDING_OBJECT_T: {
                String pscoId;
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                this.value = dPar.getDataTarget();
                boolean preserveSourceData = true;
                preserveSourceData = dAccId instanceof DataAccessId.RAccessId ? ((DataAccessId.RAccessId)dAccId).isPreserveSourceData() : (dAccId instanceof DataAccessId.RWAccessId ? ((DataAccessId.RWAccessId)dAccId).isPreserveSourceData() : false);
                String renaming = null;
                DataAccessId faId = dPar.getDataAccessId();
                if (faId instanceof DataAccessId.RWAccessId) {
                    DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)faId;
                    renaming = rwaId.getReadDataInstance().getRenaming();
                    this.dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
                } else if (faId instanceof DataAccessId.RAccessId) {
                    DataAccessId.RAccessId raId = (DataAccessId.RAccessId)faId;
                    this.dataMgmtId = renaming = raId.getReadDataInstance().getRenaming();
                } else {
                    DataAccessId.WAccessId waId = (DataAccessId.WAccessId)faId;
                    this.dataMgmtId = waId.getWrittenDataInstance().getRenaming();
                }
                if (renaming != null && (pscoId = Comm.getData(renaming).getPscoId()) != null) {
                    if (type.equals((Object)DataType.OBJECT_T)) {
                        param.setType(DataType.PSCO_T);
                    } else if (type.equals((Object)DataType.FILE_T)) {
                        param.setType(DataType.EXTERNAL_PSCO_T);
                    }
                    this.param.setType(param.getType());
                }
                this.preserveSourceData = preserveSourceData;
                this.writeFinalValue = !(dAccId instanceof DataAccessId.RAccessId);
                this.originalName = dPar.getOriginalName();
                break;
            }
            default: {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                this.value = btParB.getValue();
                this.preserveSourceData = false;
                this.writeFinalValue = false;
                this.dataMgmtId = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.param.getName();
    }

    @Override
    public void setType(DataType type) {
        this.param.setType(type);
    }

    @Override
    public DataType getType() {
        return this.param.getType();
    }

    @Override
    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    @Override
    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    @Override
    public String getPrefix() {
        return this.param.getPrefix();
    }

    @Override
    public Stream getStream() {
        return this.param.getStream();
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    @Override
    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object val) {
        this.value = val;
    }

    @Override
    public void setValueClass(Class<?> valClass) {
        this.valueClass = valClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    @Override
    public String getSourceDataId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<? extends InvocationParamURI> getSources() {
        return null;
    }

    public Parameter getParam() {
        return this.param;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.getValue() + " " + (this.isPreserveSourceData() ? "PRESERVE " : "VOLATILE ") + (this.isWriteFinalValue() ? "WRITE" : "DISMISS");
    }
}

