/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.listener.SafeCopyListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.BindingDataManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.SharedDiskManager;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class LogicalData {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String DBG_PREFIX = "[LogicalData] ";
    private final String name;
    private Object value;
    private String pscoId;
    private String bindingId;
    private final Set<DataLocation> locations = new TreeSet<DataLocation>();
    private final Set<Resource> localLocations = new TreeSet<Resource>();
    private final List<CopyInProgress> inProgress = new LinkedList<CopyInProgress>();
    private float size;
    private boolean isBeingSaved;
    private boolean isBindingData;
    private final Semaphore lockHostRemoval = new Semaphore(1);

    public LogicalData(String name) {
        this.name = name;
        this.value = null;
        this.pscoId = null;
        this.bindingId = null;
        this.isBeingSaved = false;
        this.isBindingData = false;
        this.size = 0.0f;
    }

    public String getName() {
        return this.name;
    }

    public String getPscoId() {
        return this.pscoId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Set<Resource> getAllHosts() {
        HashSet<Resource> list = new HashSet<Resource>();
        for (DataLocation loc : this.locations) {
            List<Resource> hosts;
            List<Resource> list2 = hosts = loc.getHosts();
            synchronized (list2) {
                list.addAll(hosts);
            }
        }
        return list;
    }

    public synchronized Set<Resource> getAllLocalHosts() {
        return this.localLocations;
    }

    public synchronized void addLocation(Resource res) {
        this.localLocations.add(res);
    }

    public synchronized List<MultiURI> getURIs() {
        LinkedList<MultiURI> list = new LinkedList<MultiURI>();
        for (DataLocation loc : this.locations) {
            List<MultiURI> locationURIs = loc.getURIs();
            if (locationURIs == null) continue;
            list.addAll(locationURIs);
        }
        return list;
    }

    public synchronized Set<DataLocation> getLocations() {
        return this.locations;
    }

    public synchronized void setSize(float size) {
        this.size = size;
    }

    public float getSize() {
        return this.size;
    }

    public synchronized boolean isInMemory() {
        return this.value != null;
    }

    public synchronized boolean isBindingData() {
        return this.isBindingData;
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public synchronized void addLocation(DataLocation loc) {
        this.isBeingSaved = false;
        this.locations.add(loc);
        switch (loc.getType()) {
            case PRIVATE: {
                for (Resource r : loc.getHosts()) {
                    r.addLogicalData(this);
                }
                break;
            }
            case BINDING: {
                for (Resource r : loc.getHosts()) {
                    this.isBindingData = true;
                    if (this.bindingId == null) {
                        this.bindingId = ((BindingObjectLocation)loc).getId();
                    }
                    r.addLogicalData(this);
                }
                break;
            }
            case SHARED: {
                SharedDiskManager.addLogicalData(loc.getSharedDisk(), this);
                break;
            }
            case PERSISTENT: {
                this.pscoId = ((PersistentLocation)loc).getId();
            }
        }
    }

    public synchronized Object removeValue() {
        DataLocation loc = null;
        String targetPath = DataLocation.Protocol.OBJECT_URI.getSchema() + this.name;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            loc = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath, e);
        }
        Object val = this.value;
        this.value = null;
        this.locations.remove(loc);
        return val;
    }

    public synchronized void setValue(Object o) {
        this.value = o;
    }

    public synchronized void setPscoId(String id) {
        this.pscoId = id;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void writeToStorage() throws Exception {
        if (DEBUG) {
            LOGGER.debug("[LogicalData] Writting object " + this.name + " to storage");
        }
        if (this.isBindingData) {
            String targetPath = Comm.getAppHost().getWorkingDirectory() + this.name;
            String id = this.bindingId != null ? this.bindingId : (this.value != null ? (String)this.value : this.name);
            if (id.contains("#")) {
                id = BindingObject.generate(id).getName();
            }
            if (!BindingDataManager.isInBinding(id)) {
                LOGGER.error("[LogicalData]  Error " + id + " not found in binding");
                throw new Exception(" Error " + id + " not found in binding");
            }
            if (DEBUG) {
                LOGGER.debug("[LogicalData] Writting binding object " + id + " to file " + targetPath);
            }
            BindingDataManager.storeInFile(id, targetPath);
            this.addWrittenObjectLocation(targetPath);
        } else if (this.pscoId == null) {
            String targetPath = Comm.getAppHost().getWorkingDirectory() + this.name;
            if (DEBUG) {
                LOGGER.debug("[LogicalData] Writting object " + this.name + " to file " + targetPath);
            }
            Serializer.serialize(this.value, targetPath);
            this.addWrittenObjectLocation(targetPath);
        }
        if (DEBUG) {
            LOGGER.debug("[LogicalData] Object " + this.name + " written to storage");
        }
    }

    private void addWrittenObjectLocation(String targetPath) throws IOException {
        String targetPathWithSchema = DataLocation.Protocol.FILE_URI.getSchema() + targetPath;
        SimpleURI targetURI = new SimpleURI(targetPathWithSchema);
        DataLocation loc = DataLocation.createLocation(Comm.getAppHost(), targetURI);
        this.isBeingSaved = false;
        this.locations.add(loc);
        for (Resource r : loc.getHosts()) {
            switch (loc.getType()) {
                case PRIVATE: 
                case BINDING: {
                    r.addLogicalData(this);
                    break;
                }
                case SHARED: {
                    SharedDiskManager.addLogicalData(loc.getSharedDisk(), this);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadFromStorage() throws CannotLoadException {
        if (this.value != null) {
            return;
        }
        block16: for (DataLocation loc : this.locations) {
            switch (loc.getType()) {
                case PRIVATE: 
                case SHARED: {
                    MultiURI u = loc.getURIInHost(Comm.getAppHost());
                    if (u == null) continue block16;
                    String path = u.getPath();
                    if (path.startsWith(File.separator)) {
                        try {
                            this.value = Serializer.deserialize(path);
                        }
                        catch (IOException | ClassNotFoundException e) {
                            this.value = null;
                            continue block16;
                        }
                        String targetPath = DataLocation.Protocol.OBJECT_URI.getSchema() + this.name;
                        SimpleURI uri = new SimpleURI(targetPath);
                        try {
                            DataLocation tgtLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
                            this.addLocation(tgtLoc);
                        }
                        catch (IOException e) {
                            this.value = null;
                            continue block16;
                        }
                    }
                    return;
                }
                case PERSISTENT: {
                    PersistentLocation pLoc = (PersistentLocation)loc;
                    if (Tracer.isActivated()) {
                        Tracer.emitEvent(Tracer.Event.STORAGE_GETBYID.getId(), Tracer.Event.STORAGE_GETBYID.getType());
                    }
                    try {
                        this.value = StorageItf.getByID(pLoc.getId());
                        this.pscoId = pLoc.getId();
                    }
                    catch (StorageException se) {}
                    continue block16;
                    finally {
                        if (!Tracer.isActivated()) continue block16;
                        Tracer.emitEvent(0L, Tracer.Event.STORAGE_GETBYID.getType());
                        continue block16;
                    }
                    String targetPath = DataLocation.Protocol.OBJECT_URI.getSchema() + this.name;
                    SimpleURI uri = new SimpleURI(targetPath);
                    try {
                        DataLocation tgtLoc = DataLocation.createLocation(Comm.getAppHost(), uri);
                        this.addLocation(tgtLoc);
                    }
                    catch (IOException e) {
                        this.value = null;
                        continue block16;
                    }
                    return;
                }
                case BINDING: {
                    throw new CannotLoadException("ERROR: Trying to load from storage a BINDING location");
                }
            }
        }
        throw new CannotLoadException("Object has not any valid location available in the master");
    }

    public synchronized DataLocation removeHostAndCheckLocationToSave(Resource host, Map<String, String> sharedMountPoints) {
        if (this.isBeingSaved) {
            return null;
        }
        this.lockHostRemoval_private();
        DataLocation uniqueHostLocation = null;
        Iterator<DataLocation> it = this.locations.iterator();
        block6: while (it.hasNext()) {
            DataLocation loc = it.next();
            switch (loc.getType()) {
                case PRIVATE: 
                case BINDING: {
                    if (loc.getURIInHost(host) == null) break;
                    this.isBeingSaved = true;
                    uniqueHostLocation = loc;
                    it.remove();
                    break;
                }
                case SHARED: {
                    String mountPoint;
                    if (!loc.getHosts().isEmpty()) break;
                    String sharedDisk = loc.getSharedDisk();
                    if (sharedDisk == null || (mountPoint = sharedMountPoints.get(sharedDisk)) == null || uniqueHostLocation != null) continue block6;
                    this.isBeingSaved = true;
                    String targetPath = DataLocation.Protocol.FILE_URI.getSchema() + loc.getPath();
                    try {
                        SimpleURI uri = new SimpleURI(targetPath);
                        uniqueHostLocation = DataLocation.createLocation(host, uri);
                    }
                    catch (Exception e) {
                        ErrorManager.error("ERROR: Invalid location URI " + targetPath, e);
                    }
                    break;
                }
            }
        }
        this.releaseHostRemoval_private();
        return uniqueHostLocation;
    }

    public synchronized Collection<Copy> getCopiesInProgress() {
        LinkedList<Copy> copies = new LinkedList<Copy>();
        for (CopyInProgress cp : this.inProgress) {
            copies.add(cp.getCopy());
        }
        return copies;
    }

    public synchronized MultiURI alreadyAvailable(Resource targetHost) {
        for (DataLocation loc : this.locations) {
            MultiURI u = loc.getURIInHost(targetHost);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public synchronized Copy alreadyCopying(DataLocation target) {
        for (CopyInProgress cip : this.inProgress) {
            if (!cip.hasTarget(target)) continue;
            return cip.getCopy();
        }
        return null;
    }

    public synchronized void startCopy(Copy c, DataLocation target) {
        this.inProgress.add(new CopyInProgress(c, target));
    }

    public synchronized DataLocation finishedCopy(Copy c) {
        DataLocation loc = null;
        Iterator<CopyInProgress> it = this.inProgress.iterator();
        while (it.hasNext()) {
            CopyInProgress cip = it.next();
            if (cip.c != c) continue;
            it.remove();
            loc = cip.loc;
            break;
        }
        return loc;
    }

    public synchronized void notifyToInProgressCopiesEnd(SafeCopyListener listener) {
        for (CopyInProgress cip : this.inProgress) {
            listener.addOperation();
            cip.c.addEventListener(listener);
        }
    }

    public synchronized void isObsolete() {
        for (Resource res : this.getAllHosts()) {
            res.addObsolete(this);
        }
    }

    public void lockHostRemoval() {
        this.lockHostRemoval_private();
    }

    public void releaseHostRemoval() {
        this.releaseHostRemoval_private();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Logical Data name: ").append(this.name).append("\n");
        sb.append("\t Value: ").append(this.value).append("\n");
        sb.append("\t Id: ").append(this.pscoId).append("\n");
        sb.append("\t Locations:\n");
        Set<DataLocation> set = this.locations;
        synchronized (set) {
            for (DataLocation dl : this.locations) {
                sb.append("\t\t * ").append(dl).append("\n");
            }
        }
        return sb.toString();
    }

    private void lockHostRemoval_private() {
        try {
            this.lockHostRemoval.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.error("Exception", (Throwable)e);
        }
    }

    private void releaseHostRemoval_private() {
        this.lockHostRemoval.release();
    }

    private static class CopyInProgress {
        private final Copy c;
        private final DataLocation loc;

        public CopyInProgress(Copy c, DataLocation loc) {
            this.c = c;
            this.loc = loc;
        }

        public Copy getCopy() {
            return this.c;
        }

        private boolean hasTarget(DataLocation target) {
            return this.loc.isTarget(target);
        }

        public String toString() {
            return this.c.getName() + " to " + this.loc.toString();
        }
    }
}

