/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.executor.ExecutorContext;
import es.bsc.compss.executor.external.ExecutionPlatformMirror;
import es.bsc.compss.executor.external.persistent.PersistentMirror;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.executor.types.Execution;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.invokers.OpenCLInvoker;
import es.bsc.compss.invokers.StorageInvoker;
import es.bsc.compss.invokers.binary.BinaryInvoker;
import es.bsc.compss.invokers.binary.COMPSsInvoker;
import es.bsc.compss.invokers.binary.DecafInvoker;
import es.bsc.compss.invokers.binary.MPIInvoker;
import es.bsc.compss.invokers.binary.OmpSsInvoker;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.external.persistent.CPersistentInvoker;
import es.bsc.compss.invokers.external.piped.CInvoker;
import es.bsc.compss.invokers.external.piped.PythonInvoker;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.BinaryImplementation;
import es.bsc.compss.types.implementations.COMPSsImplementation;
import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.OmpSsImplementation;
import es.bsc.compss.types.implementations.OpenCLImplementation;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Executor
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final boolean WORKER_DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_OUT_FILES = "ERROR: One or more OUT files have not been created by task with Method Definition [";
    private static final String WARN_ATOMIC_MOVE = "WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic";
    private final InvocationContext context;
    protected final ExecutorContext platform;
    protected final String id;
    protected boolean isRegistered;
    protected PipePair cPipes;
    protected PipePair pyPipes;

    public Executor(InvocationContext context, ExecutorContext platform, String executorId) {
        LOGGER.info("Executor init");
        this.context = context;
        this.platform = platform;
        this.id = executorId;
        this.isRegistered = false;
    }

    public void start() {
        LOGGER.info("Executor started");
    }

    @Override
    public void run() {
        this.start();
        this.processRequests();
        this.finish();
    }

    public void finish() {
        LOGGER.info("Executor finished");
        Collection<ExecutionPlatformMirror<?>> mirrors = this.platform.getMirrors();
        for (ExecutionPlatformMirror<?> mirror : mirrors) {
            mirror.unregisterExecutor(this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    private void processRequests() {
        while (true) {
            Execution execution;
            if ((execution = this.platform.getJob()) == null) {
                LOGGER.error("ERROR: Execution is null!!!!!");
            }
            if (execution.getInvocation() == null) break;
            Invocation invocation = execution.getInvocation();
            if (WORKER_DEBUG) {
                LOGGER.debug("Dequeuing job " + invocation.getJobId());
            }
            boolean success = this.executeTask(invocation);
            if (WORKER_DEBUG) {
                LOGGER.debug("Job " + invocation.getJobId() + " finished (success: " + success + ")");
            }
            execution.notifyEnd(success);
        }
        LOGGER.debug("Dequeued job is null");
    }

    private boolean executeTask(Invocation invocation) {
        if (invocation.getMethodImplementation().getMethodType() == AbstractMethodImplementation.MethodType.METHOD && invocation.getLang() != COMPSsConstants.Lang.JAVA && invocation.getLang() != COMPSsConstants.Lang.PYTHON && invocation.getLang() != COMPSsConstants.Lang.C) {
            LOGGER.error("Incorrect language " + (Object)((Object)invocation.getLang()) + " in job " + invocation.getJobId());
            System.err.println("Incorrect language " + (Object)((Object)invocation.getLang()) + " in job " + invocation.getJobId());
            return false;
        }
        return this.execute(invocation);
    }

    private void executeTask(ResourceManager.InvocationResources assignedResources, Invocation invocation, File taskSandboxWorkingDir) throws JobExecutionException {
        String streamsPath = this.context.getStandardStreamsPath(invocation);
        this.context.registerOutputs(streamsPath);
        PrintStream out = this.context.getThreadOutStream();
        if (invocation.isDebugEnabled()) {
            out.println("[EXECUTOR] executeTask - Begin task execution");
        }
        try {
            Invoker invoker = null;
            switch (invocation.getMethodImplementation().getMethodType()) {
                case METHOD: {
                    invoker = this.selectNativeMethodInvoker(invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case BINARY: {
                    invoker = new BinaryInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case MPI: {
                    invoker = new MPIInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case COMPSs: {
                    invoker = new COMPSsInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case DECAF: {
                    invoker = new DecafInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case MULTI_NODE: {
                    invoker = this.selectNativeMethodInvoker(invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case OMPSS: {
                    invoker = new OmpSsInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    break;
                }
                case OPENCL: {
                    invoker = new OpenCLInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                }
            }
            invoker.processTask();
        }
        catch (Exception jee) {
            out.println("[EXECUTOR] executeTask - Error in task execution");
            PrintStream err = this.context.getThreadErrStream();
            err.println("[EXECUTOR] executeTask - Error in task execution");
            this.createEmptyFile(invocation);
            jee.printStackTrace(err);
            throw jee;
        }
        finally {
            if (invocation.isDebugEnabled()) {
                out.println("[EXECUTOR] executeTask - End task execution");
            }
            this.context.unregisterOutputs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execute(Invocation invocation) {
        boolean bl;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(Tracer.Event.TASK_RUNNING.getId(), Tracer.Event.TASK_RUNNING.getType());
        }
        TaskWorkingDir twd = null;
        try {
            long startTime = System.currentTimeMillis();
            twd = this.createTaskSandbox(invocation);
            long createDuration = System.currentTimeMillis() - startTime;
            LOGGER.debug("Binding renamed files to sandboxed original names for Job " + invocation.getJobId());
            long startSL = System.currentTimeMillis();
            this.bindOriginalFilenamesToRenames(invocation, twd.getWorkingDir());
            long slDuration = System.currentTimeMillis() - startSL;
            long startCUB = System.currentTimeMillis();
            ResourceManager.InvocationResources assignedResources = this.platform.acquireResources(invocation.getJobId(), invocation.getRequirements());
            long cubDuration = System.currentTimeMillis() - startCUB;
            long execDuration = 0L;
            try {
                LOGGER.debug("Executing Task of Job " + invocation.getJobId());
                long startExec = System.currentTimeMillis();
                this.executeTask(assignedResources, invocation, twd.getWorkingDir());
                execDuration = System.currentTimeMillis() - startExec;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.context.getThreadOutStream().println("Exception executing task " + e.getMessage());
                e.printStackTrace(this.context.getThreadErrStream());
                throw e;
            }
            finally {
                LOGGER.debug("Removing renamed files to sandboxed original names for Job " + invocation.getJobId());
                long startOrig = System.currentTimeMillis();
                this.unbindOriginalFileNamesToRenames(invocation);
                long origFileDuration = System.currentTimeMillis() - startOrig;
                LOGGER.debug("Checking generated files for Job " + invocation.getJobId());
                long startCheckResults = System.currentTimeMillis();
                this.checkJobFiles(invocation);
                long checkResultsDuration = System.currentTimeMillis() - startCheckResults;
                LOGGER.info("[Profile] createSandBox: " + createDuration + " createSimLinks: " + slDuration + " bindCU: " + cubDuration + " execution" + execDuration + " restoreSimLinks: " + origFileDuration + " checkResults: " + checkResultsDuration);
            }
            bl = true;
            this.cleanTaskSandbox(twd);
            this.platform.releaseResources(invocation.getJobId());
        }
        catch (Exception e) {
            boolean bl2;
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.context.getThreadOutStream().println("Exception executing task " + e.getMessage());
                e.printStackTrace(this.context.getThreadErrStream());
                bl2 = false;
                this.cleanTaskSandbox(twd);
                this.platform.releaseResources(invocation.getJobId());
            }
            catch (Throwable throwable) {
                this.cleanTaskSandbox(twd);
                this.platform.releaseResources(invocation.getJobId());
                if (Tracer.extraeEnabled()) {
                    Tracer.emitEvent(0L, Tracer.Event.TASK_RUNNING.getType());
                }
                throw throwable;
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, Tracer.Event.TASK_RUNNING.getType());
            }
            return bl2;
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, Tracer.Event.TASK_RUNNING.getType());
        }
        return bl;
    }

    private TaskWorkingDir createTaskSandbox(Invocation invocation) throws IOException {
        TaskWorkingDir taskWD;
        String specificWD = null;
        switch (invocation.getMethodImplementation().getMethodType()) {
            case BINARY: {
                BinaryImplementation binaryImpl = (BinaryImplementation)invocation.getMethodImplementation();
                specificWD = binaryImpl.getWorkingDir();
                break;
            }
            case MPI: {
                MPIImplementation mpiImpl = (MPIImplementation)invocation.getMethodImplementation();
                specificWD = mpiImpl.getWorkingDir();
                break;
            }
            case COMPSs: {
                COMPSsImplementation compssImpl = (COMPSsImplementation)invocation.getMethodImplementation();
                specificWD = compssImpl.getWorkingDir();
                break;
            }
            case MULTI_NODE: {
                specificWD = null;
                break;
            }
            case DECAF: {
                DecafImplementation decafImpl = (DecafImplementation)invocation.getMethodImplementation();
                specificWD = decafImpl.getWorkingDir();
                break;
            }
            case OMPSS: {
                OmpSsImplementation ompssImpl = (OmpSsImplementation)invocation.getMethodImplementation();
                specificWD = ompssImpl.getWorkingDir();
                break;
            }
            case OPENCL: {
                OpenCLImplementation openclImpl = (OpenCLImplementation)invocation.getMethodImplementation();
                specificWD = openclImpl.getWorkingDir();
                break;
            }
            case METHOD: {
                specificWD = null;
            }
        }
        if (specificWD != null && !specificWD.isEmpty() && !specificWD.equals("[unassigned]")) {
            File workingDir = new File(specificWD);
            taskWD = new TaskWorkingDir(workingDir, true);
            Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
        } else {
            String completePath = this.context.getWorkingDir() + "sandBox" + File.separator + "job_" + invocation.getJobId();
            File workingDir = new File(completePath);
            taskWD = new TaskWorkingDir(workingDir, false);
            if (workingDir.exists()) {
                LOGGER.debug("Deleting folder " + workingDir.toString());
                if (!workingDir.delete()) {
                    LOGGER.warn("Cannot delete working dir folder: " + workingDir.toString());
                }
            }
            Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
        }
        return taskWD;
    }

    private void cleanTaskSandbox(TaskWorkingDir twd) {
        File workingDir;
        if (twd != null && !twd.isSpecific() && (workingDir = twd.getWorkingDir()) != null && workingDir.exists() && workingDir.isDirectory()) {
            try {
                LOGGER.debug("Deleting sandbox " + workingDir.toPath());
                FileUtils.deleteDirectory(workingDir);
            }
            catch (IOException e) {
                LOGGER.warn("Error deleting sandbox " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isMajorVersion(String file1, String file2) {
        String[] version1array = file1.split("_")[0].split("v");
        String[] version2array = file2.split("_")[0].split("v");
        if (version1array.length < 2 || version2array.length < 2) {
            return false;
        }
        Integer version1int = null;
        Integer version2int = null;
        try {
            version1int = Integer.parseInt(version1array[1]);
            version2int = Integer.parseInt(version2array[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return version1int > version2int;
    }

    private void bindOriginalFilenamesToRenames(Invocation invocation, File sandbox) throws IOException {
        for (InvocationParam invocationParam : invocation.getParams()) {
            this.bindOriginalFilenameToRenames(invocationParam, sandbox);
        }
        if (invocation.getTarget() != null) {
            LOGGER.debug("Invocation has non-null target");
            this.bindOriginalFilenameToRenames(invocation.getTarget(), sandbox);
        }
        for (InvocationParam invocationParam : invocation.getResults()) {
            this.bindOriginalFilenameToRenames(invocationParam, sandbox);
        }
    }

    private void bindOriginalFilenameToRenames(InvocationParam param, File sandbox) throws IOException {
        if (param.getType().equals((Object)DataType.FILE_T)) {
            String renamedFilePath = (String)param.getValue();
            File renamedFile = new File(renamedFilePath);
            param.setRenamedName(renamedFilePath);
            if (renamedFile.getName().equals(param.getOriginalName())) {
                param.setOriginalName(renamedFilePath);
            } else {
                String inSandboxPath = sandbox.getAbsolutePath() + File.separator + param.getOriginalName();
                LOGGER.debug("Setting Original Name to " + inSandboxPath);
                LOGGER.debug("Renamed File Path is " + renamedFilePath);
                param.setOriginalName(inSandboxPath);
                param.setValue(inSandboxPath);
                File inSandboxFile = new File(inSandboxPath);
                if (renamedFile.exists()) {
                    LOGGER.debug("File exists");
                    if (!inSandboxFile.exists()) {
                        LOGGER.debug("Creating symlink " + inSandboxFile.toPath() + " pointing to " + renamedFile.toPath());
                        Files.createSymbolicLink(inSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                    } else if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                        Path oldRenamed = Files.readSymbolicLink(inSandboxFile.toPath());
                        LOGGER.debug("Checking if " + renamedFile.getName() + " is equal to " + oldRenamed.getFileName().toString());
                        if (this.isMajorVersion(renamedFile.getName(), oldRenamed.getFileName().toString())) {
                            Files.delete(inSandboxFile.toPath());
                            Files.createSymbolicLink(inSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                        }
                    }
                }
            }
        }
    }

    private void unbindOriginalFileNamesToRenames(Invocation invocation) throws IOException, JobExecutionException {
        for (InvocationParam invocationParam : invocation.getParams()) {
            this.unbindOriginalFilenameToRename(invocationParam, invocation.getLang());
        }
        if (invocation.getTarget() != null) {
            this.unbindOriginalFilenameToRename(invocation.getTarget(), invocation.getLang());
        }
        for (InvocationParam invocationParam : invocation.getResults()) {
            this.unbindOriginalFilenameToRename(invocationParam, invocation.getLang());
        }
    }

    private void unbindOriginalFilenameToRename(InvocationParam param, COMPSsConstants.Lang lang) throws IOException, JobExecutionException {
        if (param.getType().equals((Object)DataType.FILE_T)) {
            String inSandboxPath = param.getOriginalName();
            String renamedFilePath = param.getRenamedName();
            LOGGER.debug("Treating file " + inSandboxPath);
            File inSandboxFile = new File(inSandboxPath);
            String originalFileName = inSandboxFile.getName();
            if (!inSandboxPath.equals(renamedFilePath)) {
                File renamedFile = new File(renamedFilePath);
                if (renamedFile.exists()) {
                    if (inSandboxFile.exists()) {
                        if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                            LOGGER.debug("Deleting symlink " + inSandboxFile.toPath());
                            Files.delete(inSandboxFile.toPath());
                        } else {
                            this.move(inSandboxFile.toPath(), renamedFile.toPath());
                        }
                    } else {
                        LOGGER.debug("Repeated data for " + inSandboxPath + ". Nothing to do");
                    }
                } else if (inSandboxFile.exists()) {
                    if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                        String msg = "ERROR: Unexpected case. A Problem occurred with File " + inSandboxPath + ". Either this file or the original name " + renamedFilePath + " do not exist.";
                        LOGGER.error(msg);
                        System.err.println(msg);
                        throw new JobExecutionException(msg);
                    }
                    this.move(inSandboxFile.toPath(), renamedFile.toPath());
                } else {
                    String msg = "ERROR: Output file " + inSandboxFile.toPath() + " does not exist";
                    if (lang != COMPSsConstants.Lang.C) {
                        LOGGER.error(msg);
                        System.err.println(msg);
                        throw new JobExecutionException(msg);
                    }
                }
            }
            param.setValue(renamedFilePath);
            param.setOriginalName(originalFileName);
        }
    }

    private void move(Path origFilePath, Path renamedFilePath) throws IOException {
        LOGGER.debug("Moving " + origFilePath.toString() + " to " + renamedFilePath.toString());
        try {
            Files.move(origFilePath, renamedFilePath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            LOGGER.warn(WARN_ATOMIC_MOVE);
            Files.move(origFilePath, renamedFilePath, new CopyOption[0]);
        }
    }

    private void checkJobFiles(Invocation invocation) throws JobExecutionException {
        boolean allOutFilesCreated = true;
        for (InvocationParam invocationParam : invocation.getParams()) {
            String filepath;
            File f;
            if (!invocationParam.getType().equals((Object)DataType.FILE_T) || (f = new File(filepath = (String)invocationParam.getValue())).exists() || invocation.getLang() == COMPSsConstants.Lang.C) continue;
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("ERROR: File with path '").append(filepath);
            errMsg.append("' not generated by task with Method Definition ").append(invocation.getMethodImplementation().getMethodDefinition());
            System.out.println(errMsg.toString());
            System.err.println(errMsg.toString());
            allOutFilesCreated = false;
        }
        if (!allOutFilesCreated) {
            throw new JobExecutionException(ERROR_OUT_FILES + invocation.getMethodImplementation().getMethodDefinition());
        }
    }

    private void createEmptyFile(Invocation invocation) {
        PrintStream out = this.context.getThreadOutStream();
        out.println("[EXECUTOR] executeTask - Checking if a blank file needs to be created");
        for (InvocationParam invocationParam : invocation.getParams()) {
            if (!invocationParam.getType().equals((Object)DataType.FILE_T)) continue;
            String filepath = (String)invocationParam.getValue();
            File f = new File(filepath);
            if (f.exists()) {
                f.delete();
            }
            out.println("[EXECUTOR] executeTask - Creating a new blank file");
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                System.err.println("[EXECUTOR] checkJobFiles - Error in creating a new blank file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invoker selectNativeMethodInvoker(Invocation invocation, File taskSandboxWorkingDir, ResourceManager.InvocationResources assignedResources) throws JobExecutionException {
        switch (invocation.getLang()) {
            case JAVA: {
                JavaInvoker javaInvoker = null;
                switch (this.context.getExecutionType()) {
                    case COMPSS: {
                        javaInvoker = new JavaInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                        break;
                    }
                    case STORAGE: {
                        javaInvoker = new StorageInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    }
                }
                return javaInvoker;
            }
            case PYTHON: {
                if (this.pyPipes == null) {
                    PipedMirror mirror;
                    ExecutorContext executorContext = this.platform;
                    synchronized (executorContext) {
                        mirror = (PipedMirror)this.platform.getMirror(PythonInvoker.class);
                        if (mirror == null) {
                            mirror = PythonInvoker.getMirror(this.context, this.platform);
                            this.platform.registerMirror(PythonInvoker.class, mirror);
                        }
                    }
                    this.pyPipes = mirror.registerExecutor(this.id);
                }
                return new PythonInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources, this.pyPipes);
            }
            case C: {
                ExternalInvoker cInvoker = null;
                if (this.context.isPersistentEnabled()) {
                    cInvoker = new CPersistentInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources);
                    if (!this.isRegistered) {
                        PersistentMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PersistentMirror)this.platform.getMirror(CPersistentInvoker.class);
                            if (mirror == null) {
                                mirror = CPersistentInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CPersistentInvoker.class, mirror);
                            }
                        }
                        mirror.registerExecutor(this.id);
                        this.isRegistered = true;
                    }
                } else {
                    if (this.cPipes == null) {
                        PipedMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PipedMirror)this.platform.getMirror(CInvoker.class);
                            if (mirror == null) {
                                mirror = (PipedMirror)CInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CInvoker.class, mirror);
                            }
                        }
                        this.cPipes = mirror.registerExecutor(this.id);
                    }
                    cInvoker = new CInvoker(this.context, invocation, taskSandboxWorkingDir, assignedResources, this.cPipes);
                }
                return cInvoker;
            }
        }
        throw new JobExecutionException("Unrecognised lang for a method type invocation");
    }

    private class TaskWorkingDir {
        private final File workingDir;
        private final boolean isSpecific;

        public TaskWorkingDir(File workingDir, boolean isSpecific) {
            this.workingDir = workingDir;
            this.isSpecific = isSpecific;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public boolean isSpecific() {
            return this.isSpecific;
        }
    }
}

