/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data.location;

import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.util.LinkedList;
import java.util.List;
import storage.StorageException;
import storage.StorageItf;

public class PersistentLocation
extends DataLocation {
    private final String id;

    public PersistentLocation(String id) {
        this.id = id;
    }

    @Override
    public DataLocation.Type getType() {
        return DataLocation.Type.PERSISTENT;
    }

    @Override
    public DataLocation.Protocol getProtocol() {
        return DataLocation.Protocol.PERSISTENT_URI;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public List<MultiURI> getURIs() {
        List<String> locations = null;
        try {
            locations = StorageItf.getLocations(this.id);
        }
        catch (StorageException e) {
            ErrorManager.error("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end");
        }
        if (locations == null) {
            ErrorManager.error("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end");
        }
        LinkedList<MultiURI> uris = new LinkedList<MultiURI>();
        for (String hostName : locations) {
            Resource host = ResourcesPool.getResource(hostName);
            if (host != null) {
                uris.add(new MultiURI(DataLocation.Protocol.PERSISTENT_URI, host, this.id));
                continue;
            }
            LOGGER.warn("Storage Back-End returned non-registered host " + hostName + ". Skipping URI in host");
        }
        return uris;
    }

    @Override
    public List<Resource> getHosts() {
        LOGGER.debug("Get PSCO locations for " + this.id);
        List<String> locations = null;
        try {
            locations = StorageItf.getLocations(this.id);
        }
        catch (StorageException e) {
            ErrorManager.error("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end");
        }
        if (locations == null) {
            ErrorManager.error("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end");
        }
        LinkedList<Resource> hosts = new LinkedList<Resource>();
        for (String hostName : locations) {
            Resource host = ResourcesPool.getResource(hostName);
            if (host != null) {
                hosts.add(host);
                continue;
            }
            LOGGER.warn("Storage Back-End returned non-registered host " + hostName);
        }
        return hosts;
    }

    @Override
    public MultiURI getURIInHost(Resource targetHost) {
        List<String> locations = null;
        try {
            locations = StorageItf.getLocations(this.id);
        }
        catch (StorageException e) {
            ErrorManager.error("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end");
        }
        if (locations == null) {
            ErrorManager.error("ERROR: Cannot retrieve locations of " + this.id + " from Storage Back-end");
        }
        for (String hostName : locations) {
            if (!hostName.equals(targetHost.getName())) continue;
            return new MultiURI(DataLocation.Protocol.PERSISTENT_URI, targetHost, this.id);
        }
        return null;
    }

    @Override
    public boolean isTarget(DataLocation target) {
        if (target.getType() != DataLocation.Type.PERSISTENT) {
            return false;
        }
        return this.id.equals(((PersistentLocation)target).id);
    }

    public String toString() {
        return DataLocation.Protocol.PERSISTENT_URI.getSchema() + this.id;
    }

    @Override
    public String getSharedDisk() {
        return null;
    }

    @Override
    public String getPath() {
        return this.id;
    }

    @Override
    public String getLocationKey() {
        return this.id + ":persistent:" + "allHosts";
    }

    @Override
    public int compareTo(DataLocation o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o.getClass() != PersistentLocation.class) {
            return this.getClass().getName().compareTo(PersistentLocation.class.toString());
        }
        return this.id.compareTo(((PersistentLocation)o).id);
    }

    @Override
    public void modifyPath(String path) {
    }
}

