/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.external.piped.commands;

import es.bsc.compss.executor.external.commands.ExecutorPIDReplyExternalCommand;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;
import java.util.LinkedList;
import java.util.List;

public class ExecutorPIDReplyPipeCommand
extends ExecutorPIDReplyExternalCommand
implements PipeCommand {
    private final String inPipe;
    private final String outPipe;
    private final List<Integer> pids;

    public ExecutorPIDReplyPipeCommand(String[] line) {
        this.inPipe = line[1];
        this.outPipe = line[2];
        this.pids = new LinkedList<Integer>();
        for (int idx = 3; idx < line.length; ++idx) {
            this.pids.add(Integer.parseInt(line[idx]));
        }
    }

    public ExecutorPIDReplyPipeCommand(PipePair pp) {
        this.inPipe = pp.getInboundPipe();
        this.outPipe = pp.getOutboundPipe();
        this.pids = new LinkedList<Integer>();
    }

    @Override
    public String getAsString() {
        return super.getAsString() + " " + this.inPipe + " " + this.outPipe;
    }

    @Override
    public int compareTo(PipeCommand t) {
        ExecutorPIDReplyPipeCommand rt;
        int value = Integer.compare(this.getType().ordinal(), t.getType().ordinal());
        if (value == 0) {
            rt = (ExecutorPIDReplyPipeCommand)t;
            value = this.inPipe.compareTo(rt.inPipe);
        }
        if (value == 0) {
            rt = (ExecutorPIDReplyPipeCommand)t;
            value = this.outPipe.compareTo(rt.outPipe);
        }
        return value;
    }

    @Override
    public void join(PipeCommand receivedCommand) {
        this.pids.addAll(((ExecutorPIDReplyPipeCommand)receivedCommand).pids);
    }

    public List<Integer> getPids() {
        return this.pids;
    }
}

